/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Contract;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.Currency;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.Field;
import com.ericsson.ejb.FieldDropdown;
import com.ericsson.ejb.Frequency;
import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="CM_CUSTOM_LIC_FIELD_VALUE")
public class CustomLicFieldValue
implements Serializable {
    private static final long serialVersionUID = -4821042425253021044L;
    private Long idValue;
    private LicenseDetails licenseDetails;
    private CopyrightHolder copyrightHolder;
    private Contract contract;
    private License license;
    private Field field;
    private Deal deal;
    private String value;

    public CustomLicFieldValue() {
    }

    public CustomLicFieldValue(Field field) {
        this.field = field;
    }

    public CustomLicFieldValue(LicenseDetails licenseDetails, CopyrightHolder copyrightHolder, Contract contract, License license, Field field, Deal deal, String value) {
        this.licenseDetails = licenseDetails;
        this.copyrightHolder = copyrightHolder;
        this.contract = contract;
        this.license = license;
        this.field = field;
        this.deal = deal;
        this.value = value;
    }

    @Id
    @Column(name="ID_VALUE", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="CustomLicFieldID Sequence Generator", sequenceName="CM_CUSTOM_LIC_FIELD_VALUE_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CustomLicFieldID Sequence Generator")
    public Long getIdValue() {
        return this.idValue;
    }

    public void setIdValue(Long idValue) {
        this.idValue = idValue;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LICENSEDETAILS", insertable=false, updatable=false)
    public LicenseDetails getLicenseDetails() {
        return this.licenseDetails;
    }

    public void setLicenseDetails(LicenseDetails licenseDetails) {
        this.licenseDetails = licenseDetails;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COPYRIGHTHOLDER", insertable=false, updatable=false)
    public CopyrightHolder getCopyrightHolder() {
        return this.copyrightHolder;
    }

    public void setCopyrightHolder(CopyrightHolder copyrightHolder) {
        this.copyrightHolder = copyrightHolder;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRACT", insertable=false, updatable=false)
    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LICENSE", insertable=false, updatable=false)
    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ID_FIELD", nullable=false)
    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEAL", insertable=false, updatable=false)
    public Deal getDeal() {
        return this.deal;
    }

    public void setDeal(Deal deal) {
        this.deal = deal;
    }

    @Column(name="VALUE", length=50)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Transient
    public String getDisplayableValue(List<Currency> currencies, List<Frequency> frequencies, Set<FieldDropdown> fieldDropdowns) {
        try {
            long key = Long.parseLong(this.value);
            switch (this.field.getType()) {
                case Alphanumeric: 
                case Text: {
                    if (!this.field.getDropdown().booleanValue()) break;
                    for (FieldDropdown fd : fieldDropdowns) {
                        if (fd.getIdFieldDropdown() != key) continue;
                        return fd.getValue();
                    }
                    break;
                }
                case Currency: {
                    if (currencies == null || currencies.isEmpty()) break;
                    for (Currency currency : currencies) {
                        if (currency.getIdCurrency() != key) continue;
                        return currency.getNameAndSymbol();
                    }
                    break;
                }
                case Frequency: {
                    if (frequencies == null || frequencies.isEmpty()) break;
                    for (Frequency frequency : frequencies) {
                        if (frequency.getIdFrequency() != key) continue;
                        return frequency.getDescription();
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.value;
    }
}

