/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.Platform;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CM_DEVICE")
public class Device
implements Serializable {
    private static final long serialVersionUID = 6423175720493348812L;
    private Long idDevice;
    private Platform platform;
    private String deviceName;
    private Set<LicenseDetails> licenseDetails = new HashSet<LicenseDetails>(0);

    public Device() {
    }

    public Device(Long idDevice) {
        this.idDevice = idDevice;
    }

    public Device(Platform platform, String deviceName) {
        this.platform = platform;
        this.deviceName = deviceName;
    }

    public Device(Platform platform, String deviceName, Set<LicenseDetails> licenseDetails) {
        this.platform = platform;
        this.deviceName = deviceName;
        this.licenseDetails = licenseDetails;
    }

    @Id
    @Column(name="ID_DEVICE", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="DeviceID Sequence Generator", sequenceName="CM_DEVICE_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DeviceID Sequence Generator")
    public Long getIdDevice() {
        return this.idDevice;
    }

    public void setIdDevice(Long idDevice) {
        this.idDevice = idDevice;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLATFORM", nullable=false)
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    @Column(name="DEVICE_NAME", length=250)
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="device")
    public Set<LicenseDetails> getLicenseDetails() {
        return this.licenseDetails;
    }

    public void setLicenseDetails(Set<LicenseDetails> licenseDetails) {
        this.licenseDetails = licenseDetails;
    }
}

