/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.DeliveryMethod;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.Media;
import com.ericsson.ejb.Ownership;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CM_DISTRIBUTION_MANAGEMENT")
public class DistributionManagement
implements Serializable {
    private static final long serialVersionUID = 4596915013188433989L;
    private Long idDistributionManagement;
    private LicenseDetails licenseDetails;
    private DeliveryMethod deliveryMethod;
    private Ownership ownership;
    private Media media;
    private Date deliveryDate;
    private Date dueDate;
    private BigDecimal deliveryCost;
    private Date returnDate;
    private String metadataFormat;

    public DistributionManagement() {
    }

    public DistributionManagement(LicenseDetails licenseDetails, Ownership ownership, String metadataFormat) {
        this.licenseDetails = licenseDetails;
        this.ownership = ownership;
        this.metadataFormat = metadataFormat;
    }

    public DistributionManagement(LicenseDetails licenseDetails, DeliveryMethod deliveryMethod, Ownership ownership, Media media, Date deliveryDate, Date dueDate, BigDecimal deliveryCost, Date returnDate, String metadataFormat) {
        this.licenseDetails = licenseDetails;
        this.deliveryMethod = deliveryMethod;
        this.ownership = ownership;
        this.media = media;
        this.deliveryDate = deliveryDate;
        this.dueDate = dueDate;
        this.deliveryCost = deliveryCost;
        this.returnDate = returnDate;
        this.metadataFormat = metadataFormat;
    }

    @Id
    @Column(name="ID_DISTRIBUTION_MANAGEMENT", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="DistributionManagementID Sequence Generator", sequenceName="CM_DISTRIBUTION_MANAGEMENT_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DistributionManagementID Sequence Generator")
    public Long getIdDistributionManagement() {
        return this.idDistributionManagement;
    }

    public void setIdDistributionManagement(Long idDistributionManagement) {
        this.idDistributionManagement = idDistributionManagement;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LICENSEDETAILS", nullable=false, insertable=false, updatable=false)
    public LicenseDetails getLicenseDetails() {
        return this.licenseDetails;
    }

    public void setLicenseDetails(LicenseDetails licenseDetails) {
        this.licenseDetails = licenseDetails;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DELIVERY_METHOD")
    public DeliveryMethod getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(DeliveryMethod deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OWNERSHIP")
    public Ownership getOwnership() {
        return this.ownership;
    }

    public void setOwnership(Ownership ownership) {
        this.ownership = ownership;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEDIA")
    public Media getMedia() {
        return this.media;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    @Column(name="DELIVERY_DATE")
    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    @Column(name="DUE_DATE")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Column(name="DELIVERY_COST", precision=126, scale=0)
    public BigDecimal getDeliveryCost() {
        return this.deliveryCost;
    }

    public void setDeliveryCost(BigDecimal deliveryCost) {
        this.deliveryCost = deliveryCost;
    }

    @Column(name="RETURN_DATE")
    public Date getReturnDate() {
        return this.returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }

    @Column(name="METADATA_FORMAT", length=1000)
    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }
}

