/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Currency;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Device;
import com.ericsson.ejb.DistributionManagement;
import com.ericsson.ejb.Language;
import com.ericsson.ejb.License;
import com.ericsson.ejb.Platform;
import com.ericsson.ejb.RevenuePricing;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CM_LICENSE_DETAILS", uniqueConstraints={@UniqueConstraint(columnNames={"LICENSE_ID_LICENSE", "DELIVERY_LOCATION", "LICENSE_ID_PLATFORM", "LICENSE_ID_DEVICE"})})
public class LicenseDetails
implements Serializable {
    private static final long serialVersionUID = 3071854682624581983L;
    private Long idLicensedetails;
    private License license;
    private Platform platform;
    private Currency currency;
    private Device device;
    private String deliveryLocation;
    private Long deliveryLocationId;
    private Boolean smPosterArtRequired;
    private Boolean smPreviewRequired;
    private Date smEffectiveDate;
    private Date smExpiryDate;
    private Boolean aeWatermarking;
    private Boolean aeFingerprinting;
    private Boolean aeTranscoding;
    private Boolean aeAdRemoval;
    private Boolean aeContentEdit;
    private Boolean aeQualityCheck;
    private Boolean aeContentSecurity;
    private Long prGuaranteedSubscribers;
    private BigDecimal prGuaranteedBuyRate;
    private BigDecimal prDeemedRetailPrice;
    private BigDecimal prActualRetailPrice;
    private BigDecimal prLostBuys;
    private BigDecimal prRevenueShare;
    private BigDecimal prActualLicenseFee;
    private BigDecimal prMinimumLicenseFee;
    private Boolean prUpfrontPaymentRequired;
    private BigDecimal prUpfrontPayment;
    private Boolean prOverageRequired;
    private BigDecimal prOverage;
    private Boolean prInstallmentPlanRequired;
    private BigDecimal prInstallmentPlan;
    private Boolean prTieredPricingRequired;
    private Boolean prRevenueShareRequired;
    private Set<DistributionManagement> distributionManagements = new HashSet<DistributionManagement>(0);
    private Set<CustomLicFieldValue> customLicFieldValues = new HashSet<CustomLicFieldValue>(0);
    private Set<RevenuePricing> revenuePricings = new HashSet<RevenuePricing>(0);
    private Set<Language> languages = new HashSet<Language>(0);

    public LicenseDetails() {
        this.aeAdRemoval = Boolean.FALSE;
        this.aeContentEdit = Boolean.FALSE;
        this.aeContentSecurity = Boolean.FALSE;
        this.aeFingerprinting = Boolean.FALSE;
        this.aeQualityCheck = Boolean.FALSE;
        this.aeTranscoding = Boolean.FALSE;
        this.aeWatermarking = Boolean.FALSE;
        this.smPosterArtRequired = Boolean.FALSE;
        this.smPreviewRequired = Boolean.FALSE;
        this.prOverageRequired = Boolean.FALSE;
        this.prInstallmentPlanRequired = Boolean.FALSE;
        this.prTieredPricingRequired = Boolean.FALSE;
        this.prRevenueShareRequired = Boolean.FALSE;
    }

    public LicenseDetails(License license, Platform platform, Device device, String deliveryLocation, Boolean smPosterArtRequired, Boolean smPreviewRequired, Date smEffectiveDate, Date smExpiryDate) {
        this();
        this.license = license;
        this.platform = platform;
        this.device = device;
        this.deliveryLocation = deliveryLocation;
        this.smPosterArtRequired = smPosterArtRequired;
        this.smPreviewRequired = smPreviewRequired;
        this.smEffectiveDate = smEffectiveDate;
        this.smExpiryDate = smExpiryDate;
    }

    public LicenseDetails(License license, Platform platform, Currency currency, Device device, String deliveryLocation, Boolean smPosterArtRequired, Boolean smPreviewRequired, Date smEffectiveDate, Date smExpiryDate, Boolean aeWatermarking, Boolean aeFingerprinting, Boolean aeTranscoding, Boolean aeAdRemoval, Boolean aeContentEdit, Boolean aeQualityCheck, Boolean aeContentSecurity, Long prGuaranteedSubscribers, BigDecimal prGuaranteedBuyRate, BigDecimal prDeemedRetailPrice, BigDecimal prActualRetailPrice, BigDecimal prLostBuys, BigDecimal prRevenueShare, BigDecimal prActualLicenseFee, BigDecimal prMinimumLicenseFee, Boolean prUpfrontPaymentRequired, BigDecimal prUpfrontPayment, Boolean prOverageRequired, BigDecimal prOverage, Boolean prInstallmentPlanRequired, BigDecimal prInstallmentPlan, Boolean prTieredPricingRequired, Boolean prRevenueShareRequired, Set<DistributionManagement> distributionManagements, Set<CustomLicFieldValue> customLicFieldValues, Set<RevenuePricing> revenuePricings, Set<Language> languages) {
        this();
        this.license = license;
        this.platform = platform;
        this.currency = currency;
        this.device = device;
        this.deliveryLocation = deliveryLocation;
        this.smPosterArtRequired = smPosterArtRequired;
        this.smPreviewRequired = smPreviewRequired;
        this.smEffectiveDate = smEffectiveDate;
        this.smExpiryDate = smExpiryDate;
        this.aeWatermarking = aeWatermarking;
        this.aeFingerprinting = aeFingerprinting;
        this.aeTranscoding = aeTranscoding;
        this.aeAdRemoval = aeAdRemoval;
        this.aeContentEdit = aeContentEdit;
        this.aeQualityCheck = aeQualityCheck;
        this.aeContentSecurity = aeContentSecurity;
        this.prGuaranteedSubscribers = prGuaranteedSubscribers;
        this.prGuaranteedBuyRate = prGuaranteedBuyRate;
        this.prDeemedRetailPrice = prDeemedRetailPrice;
        this.prActualRetailPrice = prActualRetailPrice;
        this.prLostBuys = prLostBuys;
        this.prRevenueShare = prRevenueShare;
        this.prActualLicenseFee = prActualLicenseFee;
        this.prMinimumLicenseFee = prMinimumLicenseFee;
        this.prUpfrontPaymentRequired = prUpfrontPaymentRequired;
        this.prUpfrontPayment = prUpfrontPayment;
        this.prOverageRequired = prOverageRequired;
        this.prOverage = prOverage;
        this.prInstallmentPlanRequired = prInstallmentPlanRequired;
        this.prInstallmentPlan = prInstallmentPlan;
        this.prTieredPricingRequired = prTieredPricingRequired;
        this.prRevenueShareRequired = prRevenueShareRequired;
        this.distributionManagements = distributionManagements;
        this.customLicFieldValues = customLicFieldValues;
        this.revenuePricings = revenuePricings;
        this.languages = languages;
    }

    @Id
    @Column(name="ID_LICENSEDETAILS", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="LicenseDetailsID Sequence Generator", sequenceName="CM_LICENSE_DETAILS_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="LicenseDetailsID Sequence Generator")
    public Long getIdLicensedetails() {
        return this.idLicensedetails;
    }

    public void setIdLicensedetails(Long idLicensedetails) {
        this.idLicensedetails = idLicensedetails;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="LICENSE_ID_LICENSE", nullable=false, insertable=false, updatable=false)
    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="LICENSE_ID_PLATFORM")
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PR_ID_CURRENCY")
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="LICENSE_ID_DEVICE")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    @Column(name="DELIVERY_LOCATION", length=2000)
    public String getDeliveryLocation() {
        return this.deliveryLocation;
    }

    public void setDeliveryLocation(String deliveryLocation) {
        this.deliveryLocation = deliveryLocation;
    }

    @Type(type="yes_no")
    @Column(name="SM_POSTER_ART_REQUIRED", nullable=false, length=1)
    public Boolean getSmPosterArtRequired() {
        return this.smPosterArtRequired;
    }

    public void setSmPosterArtRequired(Boolean smPosterArtRequired) {
        this.smPosterArtRequired = smPosterArtRequired;
    }

    @Type(type="yes_no")
    @Column(name="SM_PREVIEW_REQUIRED", nullable=false, length=1)
    public Boolean getSmPreviewRequired() {
        return this.smPreviewRequired;
    }

    public void setSmPreviewRequired(Boolean smPreviewRequired) {
        this.smPreviewRequired = smPreviewRequired;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="SM_EFFECTIVE_DATE", nullable=false)
    public Date getSmEffectiveDate() {
        return this.smEffectiveDate;
    }

    public void setSmEffectiveDate(Date smEffectiveDate) {
        this.smEffectiveDate = smEffectiveDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="SM_EXPIRY_DATE", nullable=false)
    public Date getSmExpiryDate() {
        return this.smExpiryDate;
    }

    public void setSmExpiryDate(Date smExpiryDate) {
        this.smExpiryDate = smExpiryDate;
    }

    @Type(type="yes_no")
    @Column(name="AE_WATERMARKING", length=1)
    public Boolean getAeWatermarking() {
        return this.aeWatermarking;
    }

    public void setAeWatermarking(Boolean aeWatermarking) {
        this.aeWatermarking = aeWatermarking;
    }

    @Type(type="yes_no")
    @Column(name="AE_FINGERPRINTING", length=1)
    public Boolean getAeFingerprinting() {
        return this.aeFingerprinting;
    }

    public void setAeFingerprinting(Boolean aeFingerprinting) {
        this.aeFingerprinting = aeFingerprinting;
    }

    @Type(type="yes_no")
    @Column(name="AE_TRANSCODING", length=1)
    public Boolean getAeTranscoding() {
        return this.aeTranscoding;
    }

    public void setAeTranscoding(Boolean aeTranscoding) {
        this.aeTranscoding = aeTranscoding;
    }

    @Type(type="yes_no")
    @Column(name="AE_AD_REMOVAL", length=1)
    public Boolean getAeAdRemoval() {
        return this.aeAdRemoval;
    }

    public void setAeAdRemoval(Boolean aeAdRemoval) {
        this.aeAdRemoval = aeAdRemoval;
    }

    @Type(type="yes_no")
    @Column(name="AE_CONTENT_EDIT", length=1)
    public Boolean getAeContentEdit() {
        return this.aeContentEdit;
    }

    public void setAeContentEdit(Boolean aeContentEdit) {
        this.aeContentEdit = aeContentEdit;
    }

    @Type(type="yes_no")
    @Column(name="AE_QUALITY_CHECK", length=1)
    public Boolean getAeQualityCheck() {
        return this.aeQualityCheck;
    }

    public void setAeQualityCheck(Boolean aeQualityCheck) {
        this.aeQualityCheck = aeQualityCheck;
    }

    @Type(type="yes_no")
    @Column(name="AE_CONTENT_SECURITY", length=1)
    public Boolean getAeContentSecurity() {
        return this.aeContentSecurity;
    }

    public void setAeContentSecurity(Boolean aeContentSecurity) {
        this.aeContentSecurity = aeContentSecurity;
    }

    @Column(name="PR_GUARANTEED_SUBSCRIBERS", precision=22, scale=0)
    public Long getPrGuaranteedSubscribers() {
        return this.prGuaranteedSubscribers;
    }

    public void setPrGuaranteedSubscribers(Long prGuaranteedSubscribers) {
        this.prGuaranteedSubscribers = prGuaranteedSubscribers;
    }

    @Column(name="PR_GUARANTEED_BUY_RATE", precision=126, scale=0)
    public BigDecimal getPrGuaranteedBuyRate() {
        return this.prGuaranteedBuyRate;
    }

    public void setPrGuaranteedBuyRate(BigDecimal prGuaranteedBuyRate) {
        this.prGuaranteedBuyRate = prGuaranteedBuyRate;
    }

    @Column(name="PR_DEEMED_RETAIL_PRICE", precision=126, scale=0)
    public BigDecimal getPrDeemedRetailPrice() {
        return this.prDeemedRetailPrice;
    }

    public void setPrDeemedRetailPrice(BigDecimal prDeemedRetailPrice) {
        this.prDeemedRetailPrice = prDeemedRetailPrice;
    }

    @Column(name="PR_ACTUAL_RETAIL_PRICE", precision=126, scale=0)
    public BigDecimal getPrActualRetailPrice() {
        return this.prActualRetailPrice;
    }

    public void setPrActualRetailPrice(BigDecimal prActualRetailPrice) {
        this.prActualRetailPrice = prActualRetailPrice;
    }

    @Column(name="PR_LOST_BUYS", precision=126, scale=0)
    public BigDecimal getPrLostBuys() {
        return this.prLostBuys;
    }

    public void setPrLostBuys(BigDecimal prLostBuys) {
        this.prLostBuys = prLostBuys;
    }

    @Column(name="PR_REVENUE_SHARE", precision=126, scale=0)
    public BigDecimal getPrRevenueShare() {
        return this.prRevenueShare;
    }

    public void setPrRevenueShare(BigDecimal prRevenueShare) {
        this.prRevenueShare = prRevenueShare;
    }

    @Column(name="PR_ACTUAL_LICENSE_FEE", precision=126, scale=0)
    public BigDecimal getPrActualLicenseFee() {
        return this.prActualLicenseFee;
    }

    public void setPrActualLicenseFee(BigDecimal prActualLicenseFee) {
        this.prActualLicenseFee = prActualLicenseFee;
    }

    @Column(name="PR_MINIMUM_LICENSE_FEE", precision=126, scale=0)
    public BigDecimal getPrMinimumLicenseFee() {
        return this.prMinimumLicenseFee;
    }

    public void setPrMinimumLicenseFee(BigDecimal prMinimumLicenseFee) {
        this.prMinimumLicenseFee = prMinimumLicenseFee;
    }

    @Type(type="yes_no")
    @Column(name="PR_UPFRONT_PAYMENT_REQUIRED", length=1)
    public Boolean getPrUpfrontPaymentRequired() {
        return this.prUpfrontPaymentRequired;
    }

    public void setPrUpfrontPaymentRequired(Boolean prUpfrontPaymentRequired) {
        this.prUpfrontPaymentRequired = prUpfrontPaymentRequired;
    }

    @Column(name="PR_UPFRONT_PAYMENT", precision=126, scale=0)
    public BigDecimal getPrUpfrontPayment() {
        return this.prUpfrontPayment;
    }

    public void setPrUpfrontPayment(BigDecimal prUpfrontPayment) {
        this.prUpfrontPayment = prUpfrontPayment;
    }

    @Type(type="yes_no")
    @Column(name="PR_OVERAGE_REQUIRED", length=1)
    public Boolean getPrOverageRequired() {
        return this.prOverageRequired;
    }

    public void setPrOverageRequired(Boolean prOverageRequired) {
        this.prOverageRequired = prOverageRequired;
    }

    @Column(name="PR_OVERAGE", precision=126, scale=0)
    public BigDecimal getPrOverage() {
        return this.prOverage;
    }

    public void setPrOverage(BigDecimal prOverage) {
        this.prOverage = prOverage;
    }

    @Type(type="yes_no")
    @Column(name="PR_INSTALLMENT_PLAN_REQUIRED", length=1)
    public Boolean getPrInstallmentPlanRequired() {
        return this.prInstallmentPlanRequired;
    }

    public void setPrInstallmentPlanRequired(Boolean prInstallmentPlanRequired) {
        this.prInstallmentPlanRequired = prInstallmentPlanRequired;
    }

    @Column(name="PR_INSTALLMENT_PLAN", precision=126, scale=0)
    public BigDecimal getPrInstallmentPlan() {
        return this.prInstallmentPlan;
    }

    public void setPrInstallmentPlan(BigDecimal prInstallmentPlan) {
        this.prInstallmentPlan = prInstallmentPlan;
    }

    @Type(type="yes_no")
    @Column(name="PR_TIERED_PRICING_REQUIRED", length=1)
    public Boolean getPrTieredPricingRequired() {
        return this.prTieredPricingRequired;
    }

    public void setPrTieredPricingRequired(Boolean prTieredPricingRequired) {
        this.prTieredPricingRequired = prTieredPricingRequired;
    }

    @Type(type="yes_no")
    @Column(name="PR_REVENUE_SHARE_REQUIRED", length=1)
    public Boolean getPrRevenueShareRequired() {
        return this.prRevenueShareRequired;
    }

    public void setPrRevenueShareRequired(Boolean prRevenueShareRequired) {
        this.prRevenueShareRequired = prRevenueShareRequired;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LICENSEDETAILS", nullable=false)
    public Set<DistributionManagement> getDistributionManagements() {
        return this.distributionManagements;
    }

    public void setDistributionManagements(Set<DistributionManagement> distributionManagements) {
        this.distributionManagements = distributionManagements;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LICENSEDETAILS")
    public Set<CustomLicFieldValue> getLicenseDetailsCustomLicFieldValues() {
        return this.customLicFieldValues;
    }

    public void setLicenseDetailsCustomLicFieldValues(Set<CustomLicFieldValue> customLicFieldValues) {
        this.customLicFieldValues = customLicFieldValues;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LICENSEDETAILS", nullable=false)
    public Set<RevenuePricing> getRevenuePricings() {
        return this.revenuePricings;
    }

    public void setRevenuePricings(Set<RevenuePricing> revenuePricings) {
        this.revenuePricings = revenuePricings;
    }

    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="CM_SM_LANGUAGES", joinColumns={@JoinColumn(name="ID_LICENSEDETAILS", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="ID_LANGUAGE", nullable=false, updatable=false)})
    public Set<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Set<Language> languages) {
        this.languages = languages;
    }

    public void setDeliveryLocationId(Long deliveryLocationId) {
        this.deliveryLocationId = deliveryLocationId;
    }

    @Column(name="DELIVERY_LOCATION_ID")
    public Long getDeliveryLocationId() {
        return this.deliveryLocationId;
    }
}

