/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Device;
import com.ericsson.ejb.LicenseDetails;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="CM_PLATFORM", uniqueConstraints={@UniqueConstraint(columnNames={"DESCRIPTION"})})
public class Platform
implements Serializable {
    private static final long serialVersionUID = 7068060602445280822L;
    private Long idPlatform;
    private String description;
    private Set<Device> devices = new HashSet<Device>(0);
    private Set<LicenseDetails> licenseDetails = new HashSet<LicenseDetails>(0);

    public Platform() {
    }

    public Platform(Long idPlatform) {
        this.idPlatform = idPlatform;
    }

    public Platform(String description) {
        this.description = description;
    }

    public Platform(String description, Set<Device> devices, Set<LicenseDetails> licenseDetails) {
        this.description = description;
        this.devices = devices;
        this.licenseDetails = licenseDetails;
    }

    @Id
    @Column(name="ID_PLATFORM", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="PlatformID Sequence Generator", sequenceName="CM_PLATFORM_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PlatformID Sequence Generator")
    public Long getIdPlatform() {
        return this.idPlatform;
    }

    public void setIdPlatform(Long idPlatform) {
        this.idPlatform = idPlatform;
    }

    @Column(name="DESCRIPTION", unique=true, nullable=false, length=50)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="platform", cascade={CascadeType.ALL})
    public Set<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(Set<Device> devices) {
        this.devices = devices;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="platform")
    public Set<LicenseDetails> getLicenseDetails() {
        return this.licenseDetails;
    }

    public void setLicenseDetails(Set<LicenseDetails> licenseDetails) {
        this.licenseDetails = licenseDetails;
    }
}

