/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ejb;

import com.ericsson.ejb.Currency;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.enumeration.RevenuePricingType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="CM_REVENUE_PRICING")
public class RevenuePricing
implements Serializable {
    private static final long serialVersionUID = -4909612399412579842L;
    private Long idRevenuePricing;
    private LicenseDetails licenseDetails;
    private Currency currency;
    private BigDecimal threshold;
    private Date fromDt;
    private Date toDt;
    private BigDecimal price;
    private BigDecimal penalty;
    private RevenuePricingType type;

    public RevenuePricing() {
    }

    public RevenuePricing(LicenseDetails licenseDetails, BigDecimal price) {
        this.licenseDetails = licenseDetails;
        this.price = price;
    }

    public RevenuePricing(LicenseDetails licenseDetails, Currency currency, BigDecimal threshold, Date fromDt, Date toDt, BigDecimal price, BigDecimal penalty, RevenuePricingType type) {
        this.licenseDetails = licenseDetails;
        this.currency = currency;
        this.threshold = threshold;
        this.fromDt = fromDt;
        this.toDt = toDt;
        this.price = price;
        this.penalty = penalty;
        this.type = type;
    }

    @Id
    @Column(name="ID_REVENUE_PRICING", unique=true, nullable=false, precision=22, scale=0)
    @SequenceGenerator(name="RevenuePricingID Sequence Generator", sequenceName="CM_REVENUE_PRICING_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RevenuePricingID Sequence Generator")
    public Long getIdRevenuePricing() {
        return this.idRevenuePricing;
    }

    public void setIdRevenuePricing(Long idRevenuePricing) {
        this.idRevenuePricing = idRevenuePricing;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LICENSEDETAILS", nullable=false, insertable=false, updatable=false)
    public LicenseDetails getLicenseDetails() {
        return this.licenseDetails;
    }

    public void setLicenseDetails(LicenseDetails licenseDetails) {
        this.licenseDetails = licenseDetails;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CURRENCY")
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Column(name="THRESHOLD", precision=126, scale=0)
    public BigDecimal getThreshold() {
        return this.threshold;
    }

    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    @Column(name="FROM_DT")
    public Date getFromDt() {
        return this.fromDt;
    }

    public void setFromDt(Date fromDt) {
        this.fromDt = fromDt;
    }

    @Column(name="TO_DT")
    public Date getToDt() {
        return this.toDt;
    }

    public void setToDt(Date toDt) {
        this.toDt = toDt;
    }

    @Column(name="PRICE", nullable=false, precision=126, scale=0)
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Column(name="PENALTY", precision=126, scale=0)
    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public void setPenalty(BigDecimal penalty) {
        this.penalty = penalty;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE", length=2)
    public RevenuePricingType getType() {
        return this.type;
    }

    public void setType(RevenuePricingType type) {
        this.type = type;
    }
}

