/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.services.AddAssetToLicense;
import com.ericsson.cms.contractmgmt.client.tab.audit.AuditView;
import com.ericsson.cms.contractmgmt.client.tab.config.ConfigurationView;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractListPanel;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.CopyrightHolderListPanel;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealListPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContractComponent
extends ComponentBase {
    public static final String COMPONENT_NAME = "Contract Manager";
    private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private boolean schedulerLicensed;
    private static ContractComponent instance = new ContractComponent();

    private ContractComponent() {
    }

    public static ContractComponent getInstance() {
        return instance;
    }

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.schedulerLicensed = Boolean.parseBoolean(info.get(SCHEDULER_LICENSE_KEY));
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        return portletFactories;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
            ArrayList<AddAssetToLicense> listServices = new ArrayList<AddAssetToLicense>();
            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"})) {
                listServices.add(new AddAssetToLicense());
            }
            return listServices;
        }
        return null;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        MenuItemBase menuItem = this.buildContractManagerMenuItem();
        if (menuItem != null) {
            tabs.add(menuItem);
        }
        return tabs;
    }

    private MenuItemBase buildContractManagerMenuItem() {
        ArrayList<WidgetMenuItem> contractManagerGroup = new ArrayList<WidgetMenuItem>();
        String displayName = this.constants.menuItemContractManager();
        GroupMenuItem menuItem = new GroupMenuItem("Contracts", displayName, contractManagerGroup);
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"})) {
            final CopyrightHolderListPanel copyrightHolderListPanel = new CopyrightHolderListPanel();
            WidgetMenuItem copyrightHolderView = new WidgetMenuItem("Copyright", this.constants.menuItemCopyright(), new WidgetFactory(){

                public Widget getInstance() {
                    return copyrightHolderListPanel;
                }

                public void release(Widget widget) {
                }
            }, copyrightHolderListPanel.getAnchorChangeListener());
            copyrightHolderListPanel.setReverseAnchorChangeListener(copyrightHolderView.getReverseAnchorChangeListener());
            contractManagerGroup.add(copyrightHolderView);
            final ContractListPanel contractListPanel = new ContractListPanel();
            WidgetMenuItem contractView = new WidgetMenuItem("Contract", this.constants.menuItemContract(), new WidgetFactory(){

                public Widget getInstance() {
                    return contractListPanel;
                }

                public void release(Widget widget) {
                }
            }, contractListPanel.getAnchorChangeListener());
            contractListPanel.setReverseAnchorChangeListener(contractView.getReverseAnchorChangeListener());
            contractManagerGroup.add(contractView);
            final DealListPanel dealListPanel = new DealListPanel();
            WidgetMenuItem dealView = new WidgetMenuItem("Deal", this.constants.menuItemDeal(), new WidgetFactory(){

                public Widget getInstance() {
                    return dealListPanel;
                }

                public void release(Widget widget) {
                }
            }, dealListPanel.getAnchorChangeListener());
            dealListPanel.setReverseAnchorChangeListener(dealView.getReverseAnchorChangeListener());
            contractManagerGroup.add(dealView);
            final LicenseListPanel licenseListPanel = new LicenseListPanel();
            WidgetMenuItem licenseView = new WidgetMenuItem("License", this.constants.menuItemLicense(), new WidgetFactory(){

                public Widget getInstance() {
                    licenseListPanel.clearMessages();
                    return licenseListPanel;
                }

                public void release(Widget widget) {
                }
            }, licenseListPanel.getAnchorChangeListener());
            licenseListPanel.setReverseAnchorChangeListener(licenseView.getReverseAnchorChangeListener());
            contractManagerGroup.add(licenseView);
            final ConfigurationView configurationView = new ConfigurationView();
            WidgetMenuItem configurationMenuItem = new WidgetMenuItem("Configuration", this.constants.menuItemConfiguration(), new WidgetFactory(){

                public Widget getInstance() {
                    return configurationView;
                }

                public void release(Widget widget) {
                }
            }, (WidgetMenuItem.AnchorChangeListener)configurationView.getAnchorChangeListener());
            contractManagerGroup.add(configurationMenuItem);
            final AuditView auditView = new AuditView();
            WidgetMenuItem auditWidget = new WidgetMenuItem("Audit", this.constants.menuItemAudit(), new WidgetFactory(){

                public Widget getInstance() {
                    return auditView;
                }

                public void release(Widget widget) {
                }
            });
            contractManagerGroup.add(auditWidget);
        }
        return menuItem;
    }

    public String getName() {
        return "CONTRACT_MANAGER";
    }

    public String getDisplayName() {
        return this.constants.componentDisplayName();
    }

    public boolean isSchedulerLicensed() {
        return this.schedulerLicensed;
    }
}

