/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.customfield;

import com.ericsson.cms.contractmgmt.client.Changeable;
import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.customfield.AlphaNumericValidator;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.tab.config.PercentageConverter;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.TabValueChangeHandler;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class CustomFieldFactory {
    public static final String COPYRIGHT_HOLDER_SCREEN = "COPYRIGHTHOLDER";
    public static final String CONTRACT_SCREEN = "CONTRACT";
    public static final String DEAL_SCREEN = "DEAL";
    public static final String LICENSE_SCREEN = "LICENSE";
    public static final String DISTRIBUTION_SCREEN = "DISTRIBUTION";
    public static final String STORAGE_METADATA_SCREEN = "STORAGE_METADATA";
    public static final String ASSET_ENHANCEMENT_SCREEN = "ASSET_ENHANCEMENT";
    public static final String PRICING_SCREEN = "PRICING";
    private final Changeable changeable;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);

    public CustomFieldFactory(Changeable changeable) {
        this.changeable = changeable;
    }

    public TypedTextBoxWidget<?> createTextField(UiUserDefinedField userDefinedField) {
        String defaultValue;
        TypedTextBoxWidget<?> textBox = this.createTypedTextBox(userDefinedField);
        Integer maxChars = userDefinedField.getMaxChars();
        if (userDefinedField.isDropDown() == null || !userDefinedField.isDropDown().booleanValue() && maxChars != null && maxChars > 0) {
            textBox.setMaxLength(maxChars.intValue());
        }
        if ((defaultValue = userDefinedField.getDefaultValue()) != null && !defaultValue.trim().equals("")) {
            textBox.setTextValue(defaultValue);
        }
        return textBox;
    }

    private TypedTextBoxWidget<?> createTypedTextBox(UiUserDefinedField userDefinedField) {
        if (FieldTypeEnum.Number.equals((Object)userDefinedField.getType())) {
            TypedTextBoxWidget textBoxLong = new TypedTextBoxWidget((IValueConverter)new IntegerConverter());
            textBoxLong.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
            textBoxLong.setErrorToolTip(this.messages.numberValidationErrorTooltip());
            return textBoxLong;
        }
        if (FieldTypeEnum.Percentage.equals((Object)userDefinedField.getType())) {
            TypedTextBoxWidget textBoxString = new TypedTextBoxWidget((IValueConverter)new PercentageConverter());
            textBoxString.setErrorToolTip(this.messages.positiveFloatValidationErrorTooltip());
            textBoxString.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
            return textBoxString;
        }
        TypedTextBoxWidget textBoxString = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        if (FieldTypeEnum.Alphanumeric.equals((Object)userDefinedField.getType())) {
            textBoxString = new TypedTextBoxWidget((IValueConverter)new AlphaNumericValidator());
            textBoxString.setErrorToolTip(this.messages.alphaNumericValidationErrorTooltip());
        }
        textBoxString.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        return textBoxString;
    }

    public TypedDateBoxWidget createDateField(UiUserDefinedField userDefinedField) {
        TypedDateBoxWidget dateBox = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
        dateBox.getTextBox().setMaxLength(this.constants.dateFormat().length());
        dateBox.getTextBox().setVisibleLength(this.constants.dateFormat().length());
        dateBox.setToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        dateBox.setErrorToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        String defaultValue = userDefinedField.getDefaultValue();
        if (defaultValue != null) {
            dateBox.setTextValue(defaultValue.trim());
        }
        dateBox.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        return dateBox;
    }

    public TypedListBoxWidget<String> createListBoxField(UiUserDefinedField userDefinedField) {
        TypedListBoxWidget listBox = new TypedListBoxWidget((IValueConverter)new StringConverter());
        ArrayList<UiKeyName> uiKeyNamesList = new ArrayList<UiKeyName>(userDefinedField.getKeyNames());
        Collections.sort(uiKeyNamesList, new Comparator<UiKeyName>(){

            @Override
            public int compare(UiKeyName ukn1, UiKeyName ukn2) {
                return ukn1.getName().compareTo(ukn2.getName());
            }
        });
        listBox.addItem("", null);
        for (UiKeyName keyName : uiKeyNamesList) {
            listBox.addItem(keyName.getName(), (Object)keyName.getKey().toString());
        }
        String defaultValue = userDefinedField.getDefaultValue();
        if (defaultValue != null && !defaultValue.trim().equals("")) {
            listBox.setSelectedItem((Object)defaultValue);
        }
        listBox.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        return listBox;
    }

    public void addFieldsToForm(FormContainer form, List<UiUserDefinedField> userDefinedFields, Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap) {
        for (UiUserDefinedField field : userDefinedFields) {
            TypedTextBoxWidget<?> widget = null;
            switch (field.getType()) {
                case Number: 
                case Percentage: {
                    widget = this.createTextField(field);
                    break;
                }
                case Alphanumeric: 
                case Text: {
                    if (field.isDropDown() != null && field.isDropDown().booleanValue()) {
                        widget = this.createListBoxField(field);
                        break;
                    }
                    widget = this.createTextField(field);
                    break;
                }
                case Currency: 
                case Frequency: {
                    widget = this.createListBoxField(field);
                    break;
                }
                case Date: {
                    widget = this.createDateField(field);
                }
            }
            if (widget == null) continue;
            form.addRow(field.getLabel(), widget, field.isRequired() != null && field.isRequired() != false);
            widgetCustomFieldMap.put((DataTypeWidget<?>)widget, field);
        }
    }
}

