/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.document;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.document.UploadPopupPanel;
import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;
import com.ericsson.cms.contractmgmt.client.rpc.IFileService;
import com.ericsson.cms.contractmgmt.client.rpc.IFileServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class DocumentComponentFactory {
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String DELETE_CELL_STYLE = "contract-table-cell-body-delete";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String EB_ICON_DISABLED = "ebIcon_disabled";
    private final IFileServiceAsync fileService = (IFileServiceAsync)GWT.create(IFileService.class);
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private static final String SERVER_ERROR = "An error occurred while attempting to contact the server. Please check your network connection and try again.";
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private FlexTableContainer tableDocuments;
    private List<UiDocument> documentsList;
    private final Long recordKey;
    private final ErrorPanel errorPanel;
    private final String text;
    private final UiDocumentType uiDocumentType;
    private ImageWidget removeButton;
    private RoundedDisclosureContainer docContainer;
    private ButtonWidget addButton;
    private UploadPopupPanel uploadPopup;
    private static final String DELETE_IMAGE = "cms_contractmgmt_ui/images/delete.png";

    public DocumentComponentFactory(Long recordKey, String text, UiDocumentType uiDocumentType, ErrorPanel errorPanel) {
        this.recordKey = recordKey;
        this.uiDocumentType = uiDocumentType;
        this.errorPanel = errorPanel;
        this.text = text;
        this.buildDisclosureDocuments();
    }

    public RoundedDisclosureContainer getDocumentPanel() {
        this.verifyPermissions();
        return this.docContainer;
    }

    private void buildDisclosureDocuments() {
        VerticalContainer vertical = new VerticalContainer();
        this.tableDocuments = new FlexTableContainer();
        this.tableDocuments.addStyleName(TABLE_STYLE);
        this.tableDocuments.insertRow(0);
        this.tableDocuments.getRowFormatter().addStyleName(0, ROW_STYLE);
        this.tableDocuments.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.createTableDocumentsHeader();
        vertical.add((Widget)this.tableDocuments);
        this.addButtonsDocument(vertical);
        this.docContainer = new RoundedDisclosureContainer(this.text);
        this.docContainer.add((Widget)vertical);
        this.docContainer.setOpen(true);
    }

    private void addRowDocuments(UiDocument uiDocument) {
        this.insertRowDocuments();
        int row = this.getRowDocuments();
        this.tableDocuments.getRowFormatter().setStyleName(row, row % 2 == 0 ? "table-data-even-row" : "table-data-odd-row");
        String url = String.valueOf(GWT.getModuleBaseURL()) + "downloadFile?docId=" + uiDocument.getKey() + "&docType=" + uiDocument.getDocumentType().ordinal();
        this.tableDocuments.setWidget(row, 0, (Widget)new HTML("<a href=" + url + ">" + uiDocument.getFileName() + "</a>"));
        this.tableDocuments.getCellFormatter().setStyleName(row, 0, "nwt-TableColumnPanel-dataCell-text");
        this.tableDocuments.insertCell(row, 1);
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) && this.recordKey != null) {
            this.removeButton = new ImageWidget(DELETE_IMAGE);
            this.removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)DocumentComponentFactory.this.messages.deleteDocumentConfirmation())) {
                        DocumentComponentFactory.this.busyIndicator.center();
                        final int rowIndex = DocumentComponentFactory.this.tableDocuments.getCellForEvent(event).getRowIndex();
                        final UiDocument doc = (UiDocument)DocumentComponentFactory.this.documentsList.get(rowIndex - 1);
                        DocumentComponentFactory.this.fileService.deleteAttachment(doc.getKey(), DocumentComponentFactory.this.uiDocumentType, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                DocumentComponentFactory.this.errorPanel.addMessage(caught.getLocalizedMessage());
                                DocumentComponentFactory.this.busyIndicator.hide();
                            }

                            public void onSuccess(Boolean result) {
                                DocumentComponentFactory.this.documentsList.remove(doc);
                                DocumentComponentFactory.this.busyIndicator.hide();
                                DocumentComponentFactory.this.tableDocuments.removeRow(rowIndex);
                            }
                        });
                    }
                }
            });
            this.tableDocuments.setWidget(row, 1, (Widget)this.removeButton);
            this.tableDocuments.getCellFormatter().setStyleName(row, 1, DELETE_CELL_STYLE);
        }
    }

    private void createTableDocumentsHeader() {
        this.tableDocuments.insertCell(0, 0);
        this.tableDocuments.getRowFormatter().setStyleName(0, "table-header-row");
        this.tableDocuments.getRowFormatter().addStyleName(0, "table-header-nonSortable-text");
        this.tableDocuments.getFlexCellFormatter().setStyleName(0, 0, CELL_STYLE);
        this.tableDocuments.getFlexCellFormatter().setStyleName(0, 0, CELL_HEADER_STYLE);
        this.tableDocuments.setText(0, 0, this.constants.copyrightHolderFilePath());
    }

    private void addButtonsDocument(VerticalContainer container) {
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        FormPanel.SubmitCompleteHandler submitHandler = new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(final FormPanel.SubmitCompleteEvent event) {
                UiDocument uiDocument = new UiDocument();
                uiDocument.setParentId(DocumentComponentFactory.this.recordKey);
                uiDocument.setDocumentType(DocumentComponentFactory.this.uiDocumentType);
                DocumentComponentFactory.this.fileService.uploadAttachment(DocumentComponentFactory.this.constants.filePath(), uiDocument, new AsyncCallback<UiDocument>(){

                    public void onFailure(Throwable caught) {
                        String msg = event.getResults();
                        if (msg != null) {
                            int start = msg.indexOf(">");
                            msg = msg.substring(start >= 0 ? start + 1 : 0, msg.lastIndexOf("</"));
                        }
                        Window.alert((String)("An error occurred while attempting to contact the server. Please check your network connection and try again.\n" + msg));
                        DocumentComponentFactory.this.busyIndicator.hide();
                        DocumentComponentFactory.this.uploadPopup.hide();
                    }

                    public void onSuccess(UiDocument result) {
                        DocumentComponentFactory.this.documentsList.add(result);
                        DocumentComponentFactory.this.addRowDocuments(result);
                        DocumentComponentFactory.this.busyIndicator.hide();
                        DocumentComponentFactory.this.uploadPopup.hide();
                    }
                });
            }
        };
        this.uploadPopup = new UploadPopupPanel(true, true, submitHandler, this.busyIndicator, this.recordKey, this.errorPanel);
        this.addButton = new ButtonWidget(this.constants.addDocumentButtonName());
        this.addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DocumentComponentFactory.this.uploadPopup.center();
            }
        });
        this.addButton.removeStyleName("gwt-Button");
        this.addButton.addStyleName("ebBtn");
        this.addButton.addStyleName("addgreen_button_icon");
        this.addButton.setEnabled(false);
        buttonsContainer.add((Widget)this.addButton);
        buttonsContainer.setCellVerticalAlignment((Widget)this.addButton, HasVerticalAlignment.ALIGN_MIDDLE);
        if (this.recordKey == null) {
            HelpWidget helpWidget = new HelpWidget(this.messages.addThingLater(this.constants.document()));
            buttonsContainer.add((Widget)helpWidget);
            buttonsContainer.setCellVerticalAlignment((Widget)helpWidget, HasVerticalAlignment.ALIGN_MIDDLE);
            this.addButton.addStyleName(EB_ICON_DISABLED);
        }
        container.add((Widget)buttonsContainer);
    }

    private void insertRowDocuments() {
        this.tableDocuments.insertRow(this.tableDocuments.getRowCount());
        this.tableDocuments.getRowFormatter().addStyleName(this.getRowDocuments(), ROW_STYLE);
        this.tableDocuments.getRowFormatter().addStyleName(this.getRowDocuments(), ROW_BODY_STYLE);
    }

    private int getRowDocuments() {
        return this.tableDocuments.getRowCount() - 1;
    }

    private void verifyPermissions() {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) && this.recordKey != null) {
            this.addButton.setEnabled(true);
        }
    }

    public void addRow(UiDocument uiDocument) {
        this.addRowDocuments(uiDocument);
    }

    public void setDocumentsList(List<UiDocument> documentsList) {
        this.documentsList = documentsList;
    }
}

