/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.document;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;

public class UploadPopupComposite
extends Composite {
    private FileUpload fileUpload;
    private ButtonWidget uploadButton;
    private final FormPanel form = new FormPanel();
    private ScrollContainer container;
    private final BusyIndicator busyIndicator;
    private final Long recordKey;
    private final ErrorPanel errorPanel;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);

    UploadPopupComposite(FormPanel.SubmitCompleteHandler submitHandler, BusyIndicator busyIndicator, Long recordKey, ErrorPanel errorPanel) {
        this.busyIndicator = busyIndicator;
        this.recordKey = recordKey;
        this.errorPanel = errorPanel;
        this.initialize(submitHandler);
        this.initWidget((Widget)this.container);
    }

    private void initialize(FormPanel.SubmitCompleteHandler submitHandler) {
        this.container = new ScrollContainer();
        this.fileUpload = new FileUpload();
        this.fileUpload.setName("uploadFormElement");
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) && this.recordKey != null) {
            this.fileUpload.setEnabled(true);
        } else {
            this.fileUpload.setEnabled(false);
        }
        this.fileUpload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) && UploadPopupComposite.this.recordKey != null && !UploadPopupComposite.this.fileUpload.getFilename().trim().equalsIgnoreCase("")) {
                    UploadPopupComposite.this.uploadButton.setEnabled(true);
                }
            }
        });
        this.form.setAction(String.valueOf(GWT.getModuleBaseURL()) + "uploadFile");
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.uploadButton = new ButtonWidget(this.constants.uploadButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!UploadPopupComposite.this.fileUpload.getFilename().trim().equalsIgnoreCase("")) {
                    UploadPopupComposite.this.busyIndicator.center();
                    try {
                        UploadPopupComposite.this.form.submit();
                    }
                    catch (Exception e) {
                        UploadPopupComposite.this.errorPanel.addMessage(e.getLocalizedMessage());
                    }
                }
            }
        });
        this.uploadButton.setEnabled(false);
        HorizontalPanel horizontal = new HorizontalPanel();
        horizontal.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        horizontal.add((Widget)this.fileUpload);
        this.addSpace(horizontal);
        horizontal.add((Widget)this.uploadButton);
        this.form.addSubmitCompleteHandler(submitHandler);
        this.form.add((Widget)horizontal);
        this.container.add((Widget)this.form);
    }

    private void addSpace(HorizontalPanel container) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add((Widget)label);
            space.setCellWidth((Widget)label, "10");
            container.add((Widget)space);
        }
    }
}

