/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.model;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.model.UiAsset;
import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;

public class UiLicense
implements IsSerializable {
    private Long key;
    private UiDeal deal;
    private String name;
    private UiKeyName type;
    private boolean active = true;
    private String creationDate;
    private String effectiveDate;
    private String expiryDate;
    private String notes;
    private UiContentProvider contentProvider;
    private List<UiUserDefinedField> userDefinedFields;
    private List<UiUserDefinedFieldValue> userDefinedFieldsValues;
    private List<UiDeliveryLocation> deliveryLocations;
    private List<UiPlatform> platforms;
    private List<UiDevice> devices;
    private List<UiLicenseDetails> licenseDetailsList;
    private List<UiDocument> documentsList;
    private Boolean allAssets = Boolean.TRUE;
    private List<UiAsset> assetList;
    private String externalId;

    public UiLicense() {
        this.deal = new UiDeal();
        this.type = new UiKeyName();
        this.contentProvider = new UiContentProvider();
        this.userDefinedFields = new ArrayList<UiUserDefinedField>();
        this.userDefinedFieldsValues = new ArrayList<UiUserDefinedFieldValue>();
        this.deliveryLocations = new ArrayList<UiDeliveryLocation>();
        this.platforms = new ArrayList<UiPlatform>();
        this.devices = new ArrayList<UiDevice>();
        this.licenseDetailsList = new ArrayList<UiLicenseDetails>();
        this.documentsList = new ArrayList<UiDocument>();
        this.assetList = new ArrayList<UiAsset>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public UiDeal getDeal() {
        return this.deal;
    }

    public void setDeal(UiDeal deal) {
        this.deal = deal;
    }

    public UiKeyName getType() {
        return this.type;
    }

    public void setType(UiKeyName type) {
        this.type = type;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public UiContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(UiContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public List<UiUserDefinedField> getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public List<UiUserDefinedField> getUserDefinedFields(String screenName) {
        ArrayList<UiUserDefinedField> filteredUserDefinedFieldValues = new ArrayList<UiUserDefinedField>();
        for (UiUserDefinedField field : this.userDefinedFields) {
            if (!field.getScreenName().equals(screenName)) continue;
            filteredUserDefinedFieldValues.add(field);
        }
        return filteredUserDefinedFieldValues;
    }

    public List<UiUserDefinedFieldValue> getUserDefinedFieldsValues() {
        return this.userDefinedFieldsValues;
    }

    public List<UiDeliveryLocation> getDeliveryLocations() {
        return this.deliveryLocations;
    }

    public List<UiPlatform> getPlatforms() {
        return this.platforms;
    }

    public List<UiDevice> getDevices() {
        return this.devices;
    }

    public List<UiLicenseDetails> getLicenseDetailsList() {
        return this.licenseDetailsList;
    }

    public UiLicenseDetails getDefaultLicenseDetails() {
        UiLicenseDetails licenseDetails = null;
        for (UiLicenseDetails ld : this.licenseDetailsList) {
            if (ld.getDeliveryLocation() != null) continue;
            licenseDetails = ld;
            break;
        }
        return licenseDetails;
    }

    public List<UiDocument> getDocumentsList() {
        return this.documentsList;
    }

    public Boolean getAllAssets() {
        return this.allAssets;
    }

    public void setAllAssets(Boolean allAssets) {
        this.allAssets = allAssets;
    }

    public List<UiAsset> getAssetList() {
        return this.assetList;
    }

    public void resetDefaultValues() {
        this.userDefinedFieldsValues.clear();
        UiLicenseDetails defaultLicenseDetails = this.getDefaultLicenseDetails();
        if (defaultLicenseDetails != null) {
            defaultLicenseDetails.getUserDefinedFieldValues().clear();
            for (UiUserDefinedField field : this.getUserDefinedFields("LICENSE")) {
                this.userDefinedFieldsValues.add(this.createUserDefinedFieldValue(field));
            }
        }
        for (UiLicenseDetails licenseDetails : this.licenseDetailsList) {
            licenseDetails.resetUserDefinedFieldValues();
        }
    }

    private UiUserDefinedFieldValue createUserDefinedFieldValue(UiUserDefinedField field) {
        UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();
        value.setIdUserDefinedField(field.getIdUserDefinedField());
        value.setValue(field.getDefaultValue());
        return value;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setDocumentsList(List<UiDocument> documentsList) {
        this.documentsList = documentsList;
    }
}

