/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.services;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.exception.UiContractManagerException;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.services.AddAssetToLicenseResult;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddAssetToLicense
implements ITitleService {
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "MASTER");
        _serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
    }

    public void execute(List<Long> assetIds, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        final TitleActionInput actionInput = (TitleActionInput)input;
        if (actionInput.getLicenseId() == 0L) {
            callback.onFailure((Throwable)new UiContractManagerException(this.messages.licenseRequiredFailure()));
            return;
        }
        this.contractManagerService.addAssetsToLicense(actionInput.getLicenseId(), assetIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(Void result) {
                callback.onSuccess((Object)new AddAssetToLicenseResult(actionInput.getLicenseId()));
            }
        });
    }

    public String getDescription() {
        return this.constants.addAssetToLicense();
    }

    public String getName() {
        return this.constants.addAssetToLicenseServiceName();
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        History.newItem((String)("Contracts.License.Edit?id=" + ((AddAssetToLicenseResult)result).getLicenseId()));
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return inputData.getLicenseId() != 0L;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }
}

