/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ContractFormContainer
extends FormContainer {
    private final Map<Widget, Boolean> requiredMap = new HashMap<Widget, Boolean>();
    protected static final String ERROR_STYLE = "dataTypeError";
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);

    public ContractFormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant buttonPanelHAlign) {
        super(buttonPanelHAlign);
    }

    public int addRow(LabelWidget label, Widget value, boolean markRequired) {
        this.requiredMap.put(value, markRequired);
        return super.addRow(label, value, markRequired);
    }

    public boolean validate() {
        boolean valid = true;
        this.clearAllValidationErrors();
        Set<Map.Entry<Widget, Boolean>> entrySet = this.requiredMap.entrySet();
        for (Map.Entry<Widget, Boolean> entry : entrySet) {
            Widget widget = entry.getKey();
            if (widget instanceof Panel) {
                Panel panel = (Panel)widget;
                for (Widget childWidget : panel) {
                    if (this.validate(childWidget, entry.getValue())) continue;
                    valid = false;
                }
                continue;
            }
            if (this.validate(widget, entry.getValue())) continue;
            valid = false;
        }
        return valid;
    }

    private boolean validate(Widget widget, boolean required) {
        boolean valid = true;
        FocusWidget focusWidget = null;
        if (widget instanceof FocusWidget) {
            focusWidget = (FocusWidget)widget;
        }
        DataTypeWidget dataTypeWidget = null;
        if (widget instanceof DataTypeWidget) {
            dataTypeWidget = (DataTypeWidget)widget;
        }
        if (required && (focusWidget == null || focusWidget.isEnabled()) && (dataTypeWidget == null || dataTypeWidget.isEnabled()) && widget instanceof HasValue) {
            String stringValue;
            HasValue valueWidget = (HasValue)widget;
            Object value = valueWidget.getValue();
            if (value == null) {
                valid = false;
                this.markRequiredError(widget);
            } else if (value instanceof String && (stringValue = (String)value).trim().equals("")) {
                valid = false;
                this.markRequiredError(widget);
            }
        }
        if (dataTypeWidget != null && dataTypeWidget.isEnabled() && (!dataTypeWidget.isValidValue() || dataTypeWidget.hasValidationError())) {
            valid = false;
        }
        return valid;
    }

    public void clearAllValidationErrors() {
        Set<Widget> widgets = this.requiredMap.keySet();
        for (Widget widget : widgets) {
            if (widget instanceof Panel) {
                Panel panel = (Panel)widget;
                for (Widget childWidget : panel) {
                    this.clearValidationError(childWidget);
                }
                continue;
            }
            this.clearValidationError(widget);
        }
    }

    private void clearValidationError(Widget widget) {
        if (widget instanceof DataTypeWidget) {
            ((DataTypeWidget)widget).clearValidationError();
        } else {
            widget.removeStyleDependentName(ERROR_STYLE);
        }
    }

    private void markRequiredError(Widget widget) {
        if (widget instanceof DataTypeWidget) {
            DataTypeWidget dataTypeWidget = (DataTypeWidget)widget;
            if (dataTypeWidget.isValidValue()) {
                dataTypeWidget.showValidationError(this.messages.fieldRequiredValidationErrorTooltip());
            }
        } else {
            widget.addStyleDependentName(ERROR_STYLE);
            widget.setTitle(this.messages.fieldRequiredValidationErrorTooltip());
        }
    }
}

