/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.audit;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.customfield.AuditActionEnum;
import com.ericsson.cms.contractmgmt.client.customfield.AuditTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.AuditReportResult;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.audit.UiAuditRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class AuditDataProvider
implements DataProvider<Long, UiAuditRecord> {
    UiAudit uiaudit;
    private final List<Column<?, UiAuditRecord>> columns;
    private final ColumnBase<String, UiAuditRecord> nameColumn;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiAuditRecord> parentSortFeature;
    private static final String DATE_COLUMN = "createDate";
    private static final String NAME_COLUMN = "userName";
    private static final String TYPE_COLUMN = "auditType";
    private static final String ACTION_COLUMN = "auditAction";
    private static final String MESSAGE_COLUMN = "auditMessage";
    private IBusyNotifier busyNotifier;

    public AuditDataProvider() {
        this.columns = new ArrayList();
        ColumnBase<String, UiAuditRecord> dateColumn = new ColumnBase<String, UiAuditRecord>(DATE_COLUMN, this.constants.auditTableCreateDate()){

            public View<String> getView(UiAuditRecord record) {
                return new LabelStringView(record.getAudit().getCreateDate());
            }
        };
        dateColumn.setCellStyle("nwt-TableColumnPanel-dataCell-date");
        this.columns.add((Column<?, UiAuditRecord>)dateColumn);
        this.nameColumn = new ColumnBase<String, UiAuditRecord>(NAME_COLUMN, this.constants.auditTableUserName()){

            public View<String> getView(UiAuditRecord record) {
                return new LabelStringView(String.valueOf(record.getAudit().getUserName()));
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiAuditRecord>)this.nameColumn);
        ColumnBase<String, UiAuditRecord> typeColumn = new ColumnBase<String, UiAuditRecord>(TYPE_COLUMN, this.constants.auditTableAuditType()){

            public View<String> getView(UiAuditRecord record) {
                return new LabelStringView(AuditTypeEnum.getTextByValue(record.getAudit().getAuditType()));
            }
        };
        typeColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiAuditRecord>)typeColumn);
        ColumnBase<String, UiAuditRecord> actionColumn = new ColumnBase<String, UiAuditRecord>(ACTION_COLUMN, this.constants.auditTableAuditAction()){

            public View<String> getView(UiAuditRecord record) {
                return new LabelStringView(AuditActionEnum.getTextByValue(record.getAudit().getAuditAction()));
            }
        };
        actionColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiAuditRecord>)actionColumn);
        ColumnBase<String, UiAuditRecord> messageColumn = new ColumnBase<String, UiAuditRecord>(MESSAGE_COLUMN, this.constants.auditTableMessage()){

            public View<String> getView(UiAuditRecord record) {
                return new LabelStringView(record.getAudit().getAuditMessage());
            }
        };
        messageColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiAuditRecord>)messageColumn);
    }

    public ColumnBase<String, UiAuditRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiAuditRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiAuditRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<UiAuditRecord> callback) {
    }

    public void getRecords(final AsyncCallback<List<UiAuditRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.notifyBusyStart();
        this.contractManagerService.findAuditsByFilter(start, length, this.getParentSortFeature().getSortColumnName(), this.getParentSortFeature().isAscending(), this.uiaudit, (AsyncCallback<AuditReportResult>)new NeptuneAsyncCallback<AuditReportResult>(){

            public void onNeptuneFailure(Throwable caught) {
                AuditDataProvider.this.getParentPageFeature().setRecordCount(-1);
                callback.onFailure(caught);
                AuditDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(AuditReportResult result) {
                AuditDataProvider.this.getParentPageFeature().setRecordCount(result.getTotalCount());
                ArrayList<UiAuditRecord> UiAuditRecords = new ArrayList<UiAuditRecord>();
                for (UiAudit uiAudit : result.getUiAuditsList()) {
                    UiAuditRecords.add(new UiAuditRecord(uiAudit));
                }
                callback.onSuccess(UiAuditRecords);
                AuditDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UiAuditRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiAuditRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    public void setAuditReportFilter(UiAudit uiaudit) {
        this.uiaudit = uiaudit;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

