/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.audit;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.audit.AuditDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.audit.UiAuditRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class AuditListPanel
extends Composite {
    private final AuditDataProvider dataProvider;
    private VerticalContainer mainContainer;
    private Table<Long, UiAuditRecord> table;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";

    public AuditListPanel(UiAudit uiaudit) {
        this.dataProvider = new AuditDataProvider();
        this.dataProvider.setAuditReportFilter(uiaudit);
        this.dataProvider.setBusyNotifier(new AuditDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                AuditListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                AuditListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<Long, UiAuditRecord>(){

            public void onShowDetailView(TableDetailViewEvent<Long, UiAuditRecord> event) {
            }

            public void onShowListView(TableViewEvent event) {
                AuditListPanel.this.header.setLabel(AuditListPanel.this.constants.auditReportResultTitle());
            }
        });
        PageFeatureImpl pageFeature = new PageFeatureImpl();
        this.dataProvider.setParentPageFeature((PageFeature)pageFeature);
        SortFeatureImpl sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiAuditRecord> col : this.dataProvider.getSortColumns()) {
            sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature((SortFeatureImpl<Long, UiAuditRecord>)sortFeature);
        BookmarkFeatureImpl bookmarkFeature = new BookmarkFeatureImpl();
        this.table.addSortFeature((SortFeature)sortFeature);
        this.table.addPageFeature((PageFeature)pageFeature);
        this.table.addBookmarkFeature((BookmarkFeature)bookmarkFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
    }

    public Table<Long, UiAuditRecord> getAuditTable() {
        return this.table;
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void setAuditFilter(UiAudit audit) {
        if (this.dataProvider != null) {
            this.dataProvider.setAuditReportFilter(audit);
        }
    }
}

