/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.audit;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.customfield.AuditTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.audit.AuditListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import java.util.Date;

public class AuditView
extends Composite {
    private static final String AUDIT_LISTBOX_WIDTH = "130px";
    private static final String TEXTBOXWIDGET_WIDTH = "155px";
    private static final String DATE_BOX_WIDTH = "90px";
    private static final int USER_NAME_MAX_LENGH = 50;
    private static final String STYLE_NAME = "content-ContractPanel";
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private UiAudit audit;
    private HeaderPanel header;
    private final VerticalContainer mainContainer;
    private final ContractFormContainer formContainer;
    AuditListPanel auditListPanel;
    private ButtonWidget reportButton;
    private TextBoxWidget userName;
    private static final String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";
    private static final String IMAGE_URL = "cms_contractmgmt_ui/images/ico_contracts.png";
    private static final String CONTAINER_STYLE = "contract-Container";
    private final LabelWidget startDateLabel = new LabelWidget(this.constants.auditCreateDate());
    private final LabelWidget endDateLabel = new LabelWidget(this.constants.auditCreateDateTo());
    private TypedListBoxWidget<Long> contract;
    private final TypedDateBoxWidget startDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget endDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final HorizontalContainer buttonsContainer;
    private final HorizontalContainer dateContainer;
    private final HorizontalContainer endDateLabelContainer;

    public AuditView() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.buttonsContainer = new HorizontalContainer();
        this.dateContainer = new HorizontalContainer();
        this.endDateLabelContainer = new HorizontalContainer();
        this.formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.init();
        this.initWidget((Widget)this.mainContainer);
    }

    private void init() {
        this.buildComponents();
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.formContainer);
        this.addButtons();
        this.mainContainer.add((Widget)this.buttonsContainer);
        this.verifyPermissions();
    }

    private void buildComponents() {
        Image image = new Image(IMAGE_URL);
        image.setStyleName(STYLE_HEADER_IMAGE);
        this.contract = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.contract.setWidth(AUDIT_LISTBOX_WIDTH);
        this.contract.addItem(" ", null);
        AuditTypeEnum[] auditTypeEnumArray = AuditTypeEnum.values();
        int n = auditTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuditTypeEnum auditType = auditTypeEnumArray[n2];
            this.contract.addItem(auditType.toString(), (Object)auditType.getValue());
            ++n2;
        }
        this.userName = new TextBoxWidget();
        this.userName.setWidth(TEXTBOXWIDGET_WIDTH);
        this.userName.setMaxLength(50);
        this.startDate.setWidth(DATE_BOX_WIDTH);
        this.startDate.setWidth(DATE_BOX_WIDTH);
        this.endDate.setWidth(DATE_BOX_WIDTH);
        this.formContainer.addRow(this.constants.auditUserName(), (Widget)this.userName, false);
        this.buildDateBoxesContainer();
        this.formContainer.addRow(this.startDateLabel, (Widget)this.dateContainer, false);
        this.formContainer.addRow(this.constants.auditType(), (Widget)this.contract, false);
        this.formContainer.addStyleName(CONTAINER_STYLE);
        this.header = new HeaderPanel(this.constants.auditReportTitle());
        this.header.setImage(image);
    }

    private void buildDateBoxesContainer() {
        this.dateContainer.setWidth(DATE_BOX_WIDTH);
        this.dateContainer.setCellHorizontalAlignment((Widget)this, HasHorizontalAlignment.ALIGN_LEFT);
        this.endDateLabelContainer.add((Widget)this.endDateLabel);
        this.endDateLabelContainer.setSpacing(2);
        this.dateContainer.add((Widget)this.startDate);
        this.dateContainer.add((Widget)this.endDateLabelContainer);
        this.dateContainer.add((Widget)this.endDate);
    }

    private void addButtons() {
        this.reportButton = new ButtonWidget(this.constants.auditGenerateReport(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AuditView.this.validate()) {
                    AuditView.this.commit();
                    if (AuditView.this.auditListPanel != null) {
                        AuditView.this.auditListPanel.setAuditFilter(AuditView.this.audit);
                    } else {
                        AuditView.this.auditListPanel = new AuditListPanel(AuditView.this.audit);
                        AuditView.this.mainContainer.add((Widget)AuditView.this.auditListPanel);
                    }
                    AuditView.this.auditListPanel.getAuditTable().refresh();
                }
            }
        });
        this.reportButton.removeStyleName("gwt-Button");
        this.reportButton.addStyleName("ebBtn");
        this.reportButton.addStyleName("ebBtn_color_green");
        this.reportButton.addStyleName("genreport_button_icon");
        this.reportButton.setEnabled(true);
        this.buttonsContainer.add((Widget)this.reportButton);
    }

    private boolean validate() {
        Date stDate = this.startDate.getDatePicker().getValue();
        Date edDate = this.endDate.getDatePicker().getValue();
        this.errorPanel.reset();
        boolean valid = this.formContainer.validate();
        if (stDate != null && edDate != null && !edDate.after(stDate) && !edDate.equals(stDate)) {
            valid = false;
            this.startDate.showValidationError(this.constants.auditFilterDateValidation());
        }
        if (!valid) {
            this.errorPanel.addHeading1(this.constants.auditValidationMessage());
        }
        return valid;
    }

    private void verifyPermissions() {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"})) {
            this.reportButton.setEnabled(true);
        }
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        return this;
    }

    protected void onUnload() {
        super.onUnload();
        if (this.auditListPanel != null) {
            this.resetAuditListPanel();
        }
    }

    public void commit() {
        this.checkDates();
        this.audit = new UiAudit();
        this.audit.setUserName(this.userName.getText());
        this.audit.setStartDate(this.startDate.getTextValue());
        this.audit.setEndDate(this.endDate.getTextValue());
        this.audit.setAuditType((Long)this.contract.getSelectedItem());
    }

    private void checkDates() {
        if (this.startDate.getTextValue().trim().isEmpty()) {
            this.startDate.getDatePicker().setValue(null);
        }
        if (this.endDate.getTextValue().trim().isEmpty()) {
            this.endDate.getDatePicker().setValue(null);
        }
    }

    private void resetAuditListPanel() {
        this.auditListPanel.clearMessages();
        this.mainContainer.remove(this.mainContainer.getWidgetIndex((Widget)this.auditListPanel));
        this.auditListPanel = null;
    }
}

