/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.UiUserDefinedFieldRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationDataProvider
implements DataProvider<Long, UiUserDefinedFieldRecord> {
    private final List<Column<?, UiUserDefinedFieldRecord>> columns;
    private final List<Column<?, UiUserDefinedFieldRecord>> sortColumns;
    private final ColumnBase<String, UiUserDefinedFieldRecord> orderColumn;
    private final ColumnBase<String, UiUserDefinedFieldRecord> nameColumn;
    private final ColumnBase<String, UiUserDefinedFieldRecord> typeColumn;
    private final ColumnBase<String, UiUserDefinedFieldRecord> requiredColumn;
    private final ColumnBase<String, UiUserDefinedFieldRecord> defaultValueColumn;
    private final ColumnBase<String, UiUserDefinedFieldRecord> additionalInfoColumn;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiUserDefinedFieldRecord> parentSortFeature;
    private final String screenName;
    private List<UiUserDefinedFieldRecord> userDefinedFieldRecords;
    private static final String ORDER_COLUMN = "fieldOrder";
    private static final String NAME_COLUMN = "name";
    private static final String TYPE_COLUMN = "type";
    private static final String REQUIRED_COLUMN = "required";
    private static final String DEFAULT_COLUMN = "defaultValue";
    private static final String ADDITIONAL_INFO_COLUMN = "additionalInfo";
    private IBusyNotifier busyNotifier;
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);

    public ConfigurationDataProvider(String screenName) {
        this.screenName = screenName;
        this.userDefinedFieldRecords = new ArrayList<UiUserDefinedFieldRecord>();
        this.columns = new ArrayList();
        this.sortColumns = new ArrayList();
        this.orderColumn = new ColumnBase<String, UiUserDefinedFieldRecord>(ORDER_COLUMN, this.constants.configurationOrderColumn()){

            public View<String> getView(UiUserDefinedFieldRecord record) {
                return new LabelStringView(ConfigurationDataProvider.this.getOrder(record.getUserDefinedField()));
            }
        };
        this.orderColumn.setCellStyle("nwt-TableColumnPanel-dataCell-numeric");
        this.columns.add((Column<?, UiUserDefinedFieldRecord>)this.orderColumn);
        this.sortColumns.add((Column<?, UiUserDefinedFieldRecord>)this.orderColumn);
        this.nameColumn = new ColumnBase<String, UiUserDefinedFieldRecord>(NAME_COLUMN, this.constants.configurationNameColumn()){

            public View<String> getView(UiUserDefinedFieldRecord record) {
                return new LabelStringView(record.getUserDefinedField().getLabel());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiUserDefinedFieldRecord>)this.nameColumn);
        this.sortColumns.add((Column<?, UiUserDefinedFieldRecord>)this.nameColumn);
        this.typeColumn = new ColumnBase<String, UiUserDefinedFieldRecord>(TYPE_COLUMN, this.constants.configurationTypeColumn()){

            public View<String> getView(UiUserDefinedFieldRecord record) {
                return new LabelStringView(ConfigurationDataProvider.this.getType(record.getUserDefinedField()));
            }
        };
        this.typeColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiUserDefinedFieldRecord>)this.typeColumn);
        this.sortColumns.add((Column<?, UiUserDefinedFieldRecord>)this.typeColumn);
        this.requiredColumn = new ColumnBase<String, UiUserDefinedFieldRecord>(REQUIRED_COLUMN, this.constants.configurationRequiredColumn()){

            public View<String> getView(UiUserDefinedFieldRecord record) {
                return new LabelStringView(ConfigurationDataProvider.this.getRequired(record.getUserDefinedField()));
            }
        };
        this.requiredColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiUserDefinedFieldRecord>)this.requiredColumn);
        this.sortColumns.add((Column<?, UiUserDefinedFieldRecord>)this.requiredColumn);
        this.defaultValueColumn = new ColumnBase<String, UiUserDefinedFieldRecord>(DEFAULT_COLUMN, this.constants.configurationDefaultValueColumn()){

            public View<String> getView(UiUserDefinedFieldRecord record) {
                return new LabelStringView(ConfigurationDataProvider.this.getDefaultValue(record.getUserDefinedField()));
            }
        };
        this.defaultValueColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiUserDefinedFieldRecord>)this.defaultValueColumn);
        this.sortColumns.add((Column<?, UiUserDefinedFieldRecord>)this.defaultValueColumn);
        this.additionalInfoColumn = new ColumnBase<String, UiUserDefinedFieldRecord>(ADDITIONAL_INFO_COLUMN, this.constants.configurationAdditionalInfoColumn()){

            public View<String> getView(UiUserDefinedFieldRecord record) {
                return new LabelStringView(ConfigurationDataProvider.this.getAdditionalInfo(record.getUserDefinedField()));
            }
        };
        this.additionalInfoColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiUserDefinedFieldRecord>)this.additionalInfoColumn);
    }

    private String getRequired(UiUserDefinedField userDefinedField) {
        String required = this.constants.no();
        if (userDefinedField.isRequired().booleanValue()) {
            required = this.constants.yes();
        }
        return required;
    }

    private String getDefaultValue(UiUserDefinedField userDefinedField) {
        String defaultValue = "";
        if (userDefinedField.getDefaultValue() != null) {
            try {
                long key = Long.parseLong(userDefinedField.getDefaultValue());
                switch (userDefinedField.getType()) {
                    case Alphanumeric: 
                    case Text: {
                        if (userDefinedField.isDropDown().booleanValue()) {
                            defaultValue = this.getDisplayableDefaultValue(userDefinedField, key);
                            break;
                        }
                        defaultValue = userDefinedField.getDefaultValue();
                        break;
                    }
                    case Currency: 
                    case Frequency: {
                        defaultValue = this.getDisplayableDefaultValue(userDefinedField, key);
                        break;
                    }
                    default: {
                        defaultValue = userDefinedField.getDefaultValue();
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                defaultValue = userDefinedField.getDefaultValue();
            }
        }
        return defaultValue;
    }

    private String getDisplayableDefaultValue(UiUserDefinedField userDefinedField, long key) {
        for (UiKeyName fd : userDefinedField.getKeyNames()) {
            if (fd.getKey() != key) continue;
            return fd.getName();
        }
        return userDefinedField.getDefaultValue();
    }

    private String getOrder(UiUserDefinedField userDefinedField) {
        String order = "";
        if (userDefinedField.getOrder() != null) {
            order = userDefinedField.getOrder().toString();
        }
        return order;
    }

    private String getType(UiUserDefinedField userDefinedField) {
        String type = "";
        switch (userDefinedField.getType()) {
            case Alphanumeric: {
                type = this.constants.alphanumeric();
                break;
            }
            case Currency: {
                type = this.constants.currency();
                break;
            }
            case Date: {
                type = this.constants.date();
                break;
            }
            case Frequency: {
                type = this.constants.frequency();
                break;
            }
            case Number: {
                type = this.constants.number();
                break;
            }
            case Percentage: {
                type = this.constants.percentage();
                break;
            }
            case Text: {
                type = this.constants.text();
            }
        }
        return type;
    }

    private String getAdditionalInfo(UiUserDefinedField userDefinedField) {
        StringBuilder additionalInfo = new StringBuilder();
        if (userDefinedField.isDropDown().booleanValue()) {
            additionalInfo.append(this.constants.dropDown());
            additionalInfo.append(";");
        }
        if (userDefinedField.getMinChars() != null && userDefinedField.getMinChars() > 0) {
            this.addInfo(userDefinedField, additionalInfo, this.constants.minChars(), userDefinedField.getMinChars().toString());
        }
        if (userDefinedField.getMaxChars() != null && userDefinedField.getMaxChars() > 0) {
            this.addInfo(userDefinedField, additionalInfo, this.constants.maxChars(), userDefinedField.getMaxChars().toString());
        }
        return additionalInfo.toString();
    }

    private void addInfo(UiUserDefinedField userDefinedField, StringBuilder additionalInfo, String label, String value) {
        additionalInfo.append(" ");
        additionalInfo.append(label);
        additionalInfo.append(":");
        additionalInfo.append(value);
        additionalInfo.append(";");
    }

    public ColumnBase<String, UiUserDefinedFieldRecord> getDefaultSortColumn() {
        return this.orderColumn;
    }

    public List<Column<?, UiUserDefinedFieldRecord>> getSortColumns() {
        return this.sortColumns;
    }

    public List<Column<?, UiUserDefinedFieldRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<UiUserDefinedFieldRecord> callback) {
        for (UiUserDefinedFieldRecord record : this.userDefinedFieldRecords) {
            if (!record.getKey().equals(key)) continue;
            callback.onSuccess((Object)record);
            break;
        }
    }

    public void getRecords(final AsyncCallback<List<UiUserDefinedFieldRecord>> callback) {
        this.notifyBusyStart();
        this.contractManagerService.getUserDefinedFields(this.parentSortFeature.getSortColumnName(), this.parentSortFeature.isAscending(), this.screenName, (AsyncCallback<List<UiUserDefinedField>>)new NeptuneAsyncCallback<List<UiUserDefinedField>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {
                ConfigurationDataProvider.this.userDefinedFieldRecords.clear();
                for (UiUserDefinedField uiUserDefinedField : result) {
                    ConfigurationDataProvider.this.userDefinedFieldRecords.add(new UiUserDefinedFieldRecord(uiUserDefinedField));
                }
                callback.onSuccess((Object)ConfigurationDataProvider.this.userDefinedFieldRecords);
                ConfigurationDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UiUserDefinedFieldRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiUserDefinedFieldRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

