/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponent;
import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.ConfigurationTab;
import com.ericsson.cms.contractmgmt.client.tab.config.ConfigurationViewAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.config.IConfigTabPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.ScheduleTab;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ContractConfigurableFieldDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.DealConfigurableFieldDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.DistributionConfigurableFieldDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.LicenseConfigurableFieldDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.PricingConfigurableFieldDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.StorageMetadataConfigurableFieldDataProvider;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationView
extends Composite {
    private static final String STYLE_TABCONTAINER = "config-tabContainer";
    private static final String STYLE_NAME = "content-ContractPanel";
    private final String IMAGE_URL = "cms_contractmgmt_ui/images/ico_contracts.png";
    private final String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private TabContainer tabContainer;
    private List<IConfigTabPanel> tabs;
    private final VerticalContainer mainContainer;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final ConfigurationViewAnchorChangeListener listener;

    public ConfigurationView() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        Image image = new Image("cms_contractmgmt_ui/images/ico_contracts.png");
        image.setStyleName("nwt-HeaderPanel-image");
        HeaderPanel header = new HeaderPanel(this.constants.menuItemConfiguration());
        header.setImage(image);
        this.mainContainer.add((Widget)header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.initTabs();
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        buttonsContainer.setSpacing(5);
        this.mainContainer.add((Widget)buttonsContainer);
        this.listener = new ConfigurationViewAnchorChangeListener(this);
        this.initWidget((Widget)this.mainContainer);
    }

    private void initTabs() {
        this.tabContainer = new TabContainer();
        this.tabContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int i = 0;
                while (i < ConfigurationView.this.tabs.size()) {
                    ((IConfigTabPanel)ConfigurationView.this.tabs.get(i)).setSelected(i == (Integer)event.getSelectedItem());
                    ++i;
                }
            }
        });
        this.tabContainer.addStyleName(STYLE_TABCONTAINER);
        this.tabs = new ArrayList<IConfigTabPanel>();
        this.addTabs();
        this.mainContainer.add((Widget)this.tabContainer);
    }

    private void addTabs() {
        ConfigurationTab copyrightHolderTab = new ConfigurationTab("COPYRIGHTHOLDER", this.constants.copyrightHolderTabDisplayName());
        this.tabs.add(copyrightHolderTab);
        this.tabContainer.add((Widget)copyrightHolderTab, copyrightHolderTab.getDisplayName());
        ConfigurationTab contractTab = new ConfigurationTab("CONTRACT", this.constants.contractHolderTabDisplayName(), new ConfigurableFieldListPanel(new ContractConfigurableFieldDataProvider()), true);
        this.tabs.add(contractTab);
        this.tabContainer.add((Widget)contractTab, contractTab.getDisplayName());
        ConfigurationTab dealTab = new ConfigurationTab("DEAL", this.constants.dealTabDisplayName(), new ConfigurableFieldListPanel(new DealConfigurableFieldDataProvider()), true);
        this.tabs.add(dealTab);
        this.tabContainer.add((Widget)dealTab, dealTab.getDisplayName());
        ConfigurationTab licenseTab = new ConfigurationTab("LICENSE", this.constants.licenseTabDisplayName(), new ConfigurableFieldListPanel(new LicenseConfigurableFieldDataProvider()), true);
        this.tabs.add(licenseTab);
        this.tabContainer.add((Widget)licenseTab, licenseTab.getDisplayName());
        ConfigurationTab distributionMgmtTab = new ConfigurationTab("DISTRIBUTION", this.constants.distributionTabDisplayName(), new ConfigurableFieldListPanel(new DistributionConfigurableFieldDataProvider()), true);
        this.tabs.add(distributionMgmtTab);
        this.tabContainer.add((Widget)distributionMgmtTab, distributionMgmtTab.getDisplayName());
        ConfigurationTab storageTab = new ConfigurationTab("STORAGE_METADATA", this.constants.storageTabDisplayName(), new ConfigurableFieldListPanel(new StorageMetadataConfigurableFieldDataProvider()), true);
        this.tabs.add(storageTab);
        this.tabContainer.add((Widget)storageTab, storageTab.getDisplayName());
        ConfigurationTab pricingTab = new ConfigurationTab("PRICING", this.constants.pricingTabDisplayName(), new ConfigurableFieldListPanel(new PricingConfigurableFieldDataProvider()), false);
        this.tabs.add(pricingTab);
        this.tabContainer.add((Widget)pricingTab, pricingTab.getDisplayName());
        ConfigurationTab assetTab = new ConfigurationTab("ASSET_ENHANCEMENT", this.constants.assetTabDisplayName());
        this.tabs.add(assetTab);
        this.tabContainer.add((Widget)assetTab, assetTab.getDisplayName());
        if (ContractComponent.getInstance().isSchedulerLicensed()) {
            ScheduleTab emailSchedulerTab = new ScheduleTab();
            this.tabs.add(emailSchedulerTab);
            this.tabContainer.add((Widget)emailSchedulerTab, this.constants.emailNotificationScheduler());
        }
        this.selectTab(0L);
    }

    public void selectTab(long tabIndex) {
        this.tabContainer.selectTab((int)tabIndex);
        if (tabIndex >= 0L && tabIndex < (long)this.tabs.size()) {
            this.tabs.get((int)tabIndex).setSelected(true);
        }
    }

    public ConfigurationViewAnchorChangeListener getAnchorChangeListener() {
        return this.listener;
    }
}

