/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.customfield.AlphaNumericValidator;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.tab.config.PercentageConverter;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultValueWidgetFactory {
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);

    public TypedTextBoxWidget<?> createTextField(String defaultValue, Boolean isDropDown, Integer maxChars, FieldTypeEnum fieldType) {
        TypedTextBoxWidget<?> textBox = this.createTypedTextBox(fieldType);
        if (!(isDropDown != null && isDropDown.booleanValue() || maxChars == null || maxChars <= 0)) {
            textBox.setMaxLength(maxChars.intValue());
        }
        if (defaultValue != null && !defaultValue.trim().equals("")) {
            textBox.setTextValue(defaultValue);
        }
        return textBox;
    }

    private TypedTextBoxWidget<?> createTypedTextBox(FieldTypeEnum fieldType) {
        if (FieldTypeEnum.Number.equals((Object)fieldType)) {
            TypedTextBoxWidget textBoxLong = new TypedTextBoxWidget((IValueConverter)new IntegerConverter());
            textBoxLong.setErrorToolTip(this.messages.numberValidationErrorTooltip());
            return textBoxLong;
        }
        if (FieldTypeEnum.Percentage.equals((Object)fieldType)) {
            TypedTextBoxWidget textBoxString = new TypedTextBoxWidget((IValueConverter)new PercentageConverter());
            textBoxString.setErrorToolTip(this.messages.positiveFloatValidationErrorTooltip());
            return textBoxString;
        }
        TypedTextBoxWidget textBoxString = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        if (FieldTypeEnum.Alphanumeric.equals((Object)fieldType)) {
            textBoxString = new TypedTextBoxWidget((IValueConverter)new AlphaNumericValidator());
            textBoxString.setErrorToolTip(this.messages.alphaNumericValidationErrorTooltip());
        }
        return textBoxString;
    }

    public TypedDateBoxWidget createDateField(String defaultValue) {
        TypedDateBoxWidget dateBox = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
        dateBox.getTextBox().setMaxLength(this.constants.dateFormat().length());
        dateBox.getTextBox().setVisibleLength(this.constants.dateFormat().length());
        dateBox.setToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        dateBox.setErrorToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        if (defaultValue != null) {
            dateBox.setTextValue(defaultValue.trim());
        }
        return dateBox;
    }

    public TypedListBoxWidget<String> createListBoxField(List<UiKeyName> uiKeyNamesList, String defaultValue) {
        TypedListBoxWidget listBox = new TypedListBoxWidget((IValueConverter)new StringConverter());
        Collections.sort(uiKeyNamesList, new Comparator<UiKeyName>(){

            @Override
            public int compare(UiKeyName ukn1, UiKeyName ukn2) {
                return ukn1.getName().compareTo(ukn2.getName());
            }
        });
        listBox.addItem("", null);
        for (UiKeyName keyName : uiKeyNamesList) {
            listBox.addItem(keyName.getName(), (Object)keyName.getKey().toString());
        }
        if (defaultValue != null && !defaultValue.trim().equals("")) {
            listBox.setSelectedItem((Object)defaultValue);
        }
        return listBox;
    }

    public DataTypeWidget<?> createDefaultValueWidget(FieldTypeEnum fieldType, Boolean isDropDown, List<UiKeyName> uiKeyNamesList, String defaultValue, Integer maxChars) {
        Object widget = null;
        switch (fieldType) {
            case Currency: 
            case Frequency: {
                widget = this.createListBoxField(uiKeyNamesList, defaultValue);
                break;
            }
            case Date: {
                widget = this.createDateField(defaultValue);
                break;
            }
            case Number: 
            case Percentage: {
                widget = this.createTextField(defaultValue, isDropDown, maxChars, fieldType);
                break;
            }
            default: {
                widget = isDropDown != null && isDropDown != false ? this.createListBoxField(uiKeyNamesList, defaultValue) : this.createTextField(defaultValue, isDropDown, maxChars, fieldType);
            }
        }
        return widget;
    }
}

