/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleType;
import com.ericsson.cms.scheduling.ui.client.widgets.TimeEntryWidget;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.ArrayList;
import java.util.List;

public class EveryDayRow
extends HorizontalContainer {
    private static final int EVERY_DAY = 1;
    Label everyLabel;
    private TimeEntryWidget timeEntryWidget;
    private static ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);

    public EveryDayRow() {
        Label everyDay = new Label(constants.everyDayAtLabel());
        this.add((Widget)everyDay);
        this.timeEntryWidget = new TimeEntryWidget();
        this.timeEntryWidget.getComboBoxWidget().setWidth(80);
        this.add((Widget)this.timeEntryWidget);
        this.setCellVerticalAlignment((Widget)everyDay, HasVerticalAlignment.ALIGN_MIDDLE);
        this.setCellVerticalAlignment((Widget)this.timeEntryWidget, HasVerticalAlignment.ALIGN_MIDDLE);
    }

    public ScheduleType getScheduleType() {
        return ScheduleType.EVERY_N_DAYS;
    }

    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleType(this.getScheduleType());
        scheduleInfo.setnDays(1);
        scheduleInfo.setSpecificTime(this.timeEntryWidget.getTime());
        return scheduleInfo;
    }

    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        if (scheduleInfo == null) {
            return;
        }
        this.timeEntryWidget.setTime(scheduleInfo.getSpecificTime());
    }

    public void reset() {
        this.timeEntryWidget.reset();
    }

    public List<String> validate() {
        ArrayList<String> validationMessages = new ArrayList<String>();
        validationMessages.addAll(this.timeEntryWidget.validate());
        return validationMessages;
    }

    public static String getScheduleInfoString(ScheduleInfo scheduleInfo) {
        String scheduleInfoString = "";
        if (scheduleInfo != null) {
            scheduleInfoString = constants.everyDayAtLabel();
            scheduleInfoString = String.valueOf(scheduleInfoString) + " ";
            scheduleInfoString = String.valueOf(scheduleInfoString) + scheduleInfo.getSpecificTime();
        }
        return scheduleInfoString;
    }
}

