/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.EveryDayRow;
import com.ericsson.cms.contractmgmt.client.tab.config.ScheduleTab;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class SchedulePanel
extends VerticalContainer {
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    EveryDayRow schedulingWidget;
    private ScheduleTab parent;

    public SchedulePanel(ScheduleTab parent) {
        this.parent = parent;
        this.schedulingWidget = new EveryDayRow();
        this.schedulingWidget.setVisible(true);
        this.add((Widget)this.schedulingWidget);
        final BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.center();
        this.contractManagerService.getSchedule((AsyncCallback<ScheduleInfo>)new NeptuneAsyncCallback<ScheduleInfo>(){

            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                if (caught instanceof ValidationException) {
                    ValidationException ve = (ValidationException)caught;
                    SchedulePanel.this.addWarningMessages(ve.getValidationMessages());
                } else {
                    SchedulePanel.this.addWarningMessage(caught.getLocalizedMessage());
                }
            }

            public void onNeptuneSuccess(ScheduleInfo scheduleInfo) {
                busyIndicator.hide();
                if (scheduleInfo != null) {
                    SchedulePanel.this.schedulingWidget.setScheduleInfo(scheduleInfo);
                    SchedulePanel.this.schedulingWidget.setVisible(true);
                }
            }
        });
    }

    private void addWarningMessage(String msg) {
        this.parent.addWarningMessage(msg);
    }

    private void addWarningMessages(List<String> msgs) {
        for (String msg : msgs) {
            this.parent.addWarningMessage(msg);
        }
    }
}

