/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.IConfigTabPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.SchedulePanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class ScheduleTab
extends VerticalContainer
implements IConfigTabPanel {
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    VerticalContainer warningMessages = new VerticalContainer();
    SchedulePanel schedulePanel = new SchedulePanel(this);
    private RoundedDisclosureContainer schedulePanelContainer;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private static final String STYLE_NAME = "configuration-panel";

    public ScheduleTab() {
        HorizontalContainer buttonContainer = new HorizontalContainer();
        buttonContainer.addStyleName("cms_button_container");
        LabelWidget label1 = new LabelWidget();
        this.add((Widget)label1);
        this.setCellHeight((Widget)label1, "10");
        this.add((Widget)this.warningMessages);
        LabelWidget label2 = new LabelWidget();
        this.add((Widget)label2);
        this.setCellHeight((Widget)label2, "10");
        this.schedulePanelContainer = new RoundedDisclosureContainer(this.constants.scheduleLabel());
        this.schedulePanelContainer.setOpen(true);
        this.schedulePanelContainer.addStyleName(STYLE_NAME);
        this.schedulePanelContainer.add((Widget)this.schedulePanel);
        this.add((Widget)this.schedulePanelContainer);
        LabelWidget label3 = new LabelWidget();
        this.add((Widget)label3);
        this.setCellHeight((Widget)label3, "10");
        ButtonWidget saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ScheduleTab.this.clearWarningMessages();
                if (ScheduleTab.this.validate()) {
                    ScheduleTab.this.contractManagerService.saveSchedule(ScheduleTab.this.schedulePanel.schedulingWidget.getScheduleInfo(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            if (caught instanceof ValidationException) {
                                ValidationException ve = (ValidationException)caught;
                                ScheduleTab.this.addWarningMessages(ve.getValidationMessages());
                            } else {
                                ScheduleTab.this.addWarningMessage(caught.getLocalizedMessage());
                            }
                        }

                        public void onNeptuneSuccess(Void result) {
                            ScheduleTab.this.addSuccessMessage(ScheduleTab.this.messages.saveScheduleSucceeded());
                        }
                    });
                }
            }
        });
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        saveButton.addStyleName("ebBtn_color_green");
        saveButton.addStyleName("save_button_icon");
        buttonContainer.add((Widget)saveButton);
        ButtonWidget deleteButton = new ButtonWidget(this.constants.deleteButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ScheduleTab.this.clearWarningMessages();
                ScheduleTab.this.confirm(ScheduleTab.this.constants.confirmScheduleDeletion(), new Command(){

                    public void execute() {
                        ScheduleTab.this.contractManagerService.saveSchedule(null, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                            public void onNeptuneFailure(Throwable caught) {
                                if (caught instanceof ValidationException) {
                                    ValidationException ve = (ValidationException)caught;
                                    ScheduleTab.this.addWarningMessages(ve.getValidationMessages());
                                } else {
                                    ScheduleTab.this.addWarningMessage(caught.getLocalizedMessage());
                                }
                            }

                            public void onNeptuneSuccess(Void result) {
                                ((this).this).ScheduleTab.this.schedulePanel.schedulingWidget.reset();
                                ScheduleTab.this.addSuccessMessage(ScheduleTab.this.messages.deleteScheduleSucceeded());
                            }
                        });
                    }
                }, new Command(){

                    public void execute() {
                    }
                });
            }
        });
        deleteButton.removeStyleName("gwt-Button");
        deleteButton.addStyleName("ebBtn");
        deleteButton.addStyleName("delete_button_icon");
        buttonContainer.add((Widget)deleteButton);
        this.add((Widget)buttonContainer);
    }

    private boolean validate() {
        boolean validateResult = true;
        this.clearWarningMessages();
        List<String> validationMessages = this.schedulePanel.schedulingWidget.validate();
        if (validationMessages.size() > 0) {
            validateResult = false;
            for (String validationMessage : validationMessages) {
                this.addWarningMessage(validationMessage);
            }
        }
        return validateResult;
    }

    private void addSuccessMessage(String msg) {
        LabelWidget message = new LabelWidget(msg);
        this.warningMessages.add((Widget)message);
    }

    void addWarningMessage(String msg) {
        LabelWidget message = new LabelWidget(msg);
        message.addStyleName("red-txt");
        this.warningMessages.add((Widget)message);
    }

    private void addWarningMessages(List<String> msgs) {
        for (String msg : msgs) {
            this.addWarningMessage(msg);
        }
    }

    private void clearWarningMessages() {
        this.warningMessages.clear();
    }

    private void confirm(String confirmationText, final Command okCommand, final Command cancelCommand) {
        final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
        dialogBox.setText(confirmationText);
        ButtonWidget yesButton = new ButtonWidget(this.constants.buttonLabelOk());
        yesButton.removeStyleName("gwt-Button");
        yesButton.addStyleName("ebBtn");
        yesButton.addStyleName("ebBtn_color_green");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (okCommand != null) {
                    okCommand.execute();
                }
            }
        });
        ButtonWidget noButton = new ButtonWidget(this.constants.cancelButtonName());
        noButton.removeStyleName("gwt-Button");
        noButton.addStyleName("ebBtn");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (cancelCommand != null) {
                    cancelCommand.execute();
                }
            }
        });
        HorizontalContainer buttonPanel = new HorizontalContainer();
        dialogBox.setWidget((Widget)buttonPanel);
        buttonPanel.add((Widget)yesButton);
        buttonPanel.setCellHorizontalAlignment((Widget)yesButton, HasHorizontalAlignment.ALIGN_RIGHT);
        buttonPanel.add((Widget)noButton);
        buttonPanel.setCellHorizontalAlignment((Widget)noButton, HasHorizontalAlignment.ALIGN_LEFT);
        buttonPanel.addStyleName("cms_button_container");
        dialogBox.center();
        dialogBox.show();
    }

    @Override
    public void setSelected(boolean selected) {
        this.clearWarningMessages();
    }
}

