/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.config.UiUserDefinedFieldRecord;
import com.ericsson.cms.contractmgmt.client.tab.config.UserDefinedFieldDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.UserDefinedFieldListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.ArrayList;
import java.util.List;

public class UserDefinedFieldDetailFeature
extends AbstractDetailFeature<Long, UiUserDefinedFieldRecord> {
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final String screenName;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private UserDefinedFieldListPanel parentPanel;

    public UserDefinedFieldDetailFeature(UserDefinedFieldListPanel parentPanel, String screenName) {
        super((KeySerializer)new UiLongKeySerializer());
        this.screenName = screenName;
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiUserDefinedFieldRecord> records, final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (Window.confirm((String)this.messages.deleteFieldConfirmation())) {
                ArrayList<UiUserDefinedField> fields = new ArrayList<UiUserDefinedField>();
                for (UiUserDefinedFieldRecord record : records) {
                    fields.add(record.getUserDefinedField());
                }
                this.parentPanel.clearMessages();
                this.contractManagerService.deleteUserDefinedFields(fields, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        UserDefinedFieldDetailFeature.this.parentPanel.getUserDefinedFieldsTable().refresh();
                        UserDefinedFieldDetailFeature.this.parentPanel.getErrorPanel().showMessage(UserDefinedFieldDetailFeature.this.messages.deleteFieldError());
                        if (caught instanceof ValidationException) {
                            ValidationException ve = (ValidationException)caught;
                            for (String message : ve.getValidationMessages()) {
                                UserDefinedFieldDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                            }
                        } else {
                            callback.onFailure(caught);
                        }
                    }

                    public void onNeptuneSuccess(Void result) {
                        UserDefinedFieldDetailFeature.this.parentPanel.getSuccessPanel().showMessage(UserDefinedFieldDetailFeature.this.messages.deleteFieldSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)this.messages.noFieldSelected());
        }
    }

    public void getNew(AsyncCallback<UiUserDefinedFieldRecord> callback) {
        this.parentPanel.clearMessages();
        callback.onSuccess((Object)new UiUserDefinedFieldRecord(new UiUserDefinedField(this.screenName)));
    }

    public DetailView<Long, UiUserDefinedFieldRecord> getView(UiUserDefinedFieldRecord record, DetailViewCallback<Long, UiUserDefinedFieldRecord> callback) {
        this.parentPanel.clearMessages();
        UserDefinedFieldDetailView view = new UserDefinedFieldDetailView(this.parentPanel, record, callback);
        return view;
    }

    public boolean hasDetailLink(Column<?, UiUserDefinedFieldRecord> column) {
        return column.getDisplayName().equals(this.constants.contractNameColumn()) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
    }

    public void save(UiUserDefinedFieldRecord record, final AsyncCallback<Void> callback) {
        this.parentPanel.clearMessages();
        this.contractManagerService.saveUserDefinedField(record.getUserDefinedField(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                UserDefinedFieldDetailFeature.this.parentPanel.getErrorPanel().showMessage(UserDefinedFieldDetailFeature.this.messages.saveFieldError());
                if (caught instanceof ValidationException) {
                    ValidationException ve = (ValidationException)caught;
                    for (String message : ve.getValidationMessages()) {
                        UserDefinedFieldDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                    }
                } else {
                    callback.onFailure(caught);
                }
            }

            public void onNeptuneSuccess(Void result) {
                UserDefinedFieldDetailFeature.this.parentPanel.getSuccessPanel().showMessage(UserDefinedFieldDetailFeature.this.messages.saveFieldSucceeded());
                callback.onSuccess(null);
            }
        });
    }

    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
    }

    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
    }
}

