/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.DefaultValueWidgetFactory;
import com.ericsson.cms.contractmgmt.client.tab.config.PositiveIntegerConverter;
import com.ericsson.cms.contractmgmt.client.tab.config.UiUserDefinedFieldRecord;
import com.ericsson.cms.contractmgmt.client.tab.config.UserDefinedFieldListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyListTable;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom.CustomListTable;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericListTable;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class UserDefinedFieldDetailView
extends Composite
implements DetailView<Long, UiUserDefinedFieldRecord> {
    private static final String PANEL_STYLE = "configuration-panel";
    private static final String ERROR_STYLE = "dataTypeError";
    private static final String REQUIRED_ROW_STYLE = "contract-requiredRow";
    private static final int MIN_LENGTH = 0;
    private static final int MAX_LENGTH = 50;
    private static final int MAX_INT_VALUE = 50;
    private static final long FREE_TYPE = 0L;
    private static final long DROP_DOWN = 1L;
    private final UiUserDefinedFieldRecord record;
    private final VerticalContainer mainContainer;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private final TextBoxWidget nameTextBox = new TextBoxWidget();
    private TypedListBoxWidget<Long> fieldTypeListBox;
    private RadioButtonWidget requiredYes;
    private RadioButtonWidget requiredNo;
    private DataTypeWidget<?> defaultValueWidget = null;
    private TypedTextBoxWidget<Integer> maxCharsTextBox;
    private TypedTextBoxWidget<Integer> minCharsTextBox;
    private TypedTextBoxWidget<Integer> orderTextBox;
    private int fillTypeRow;
    private int minCharsRow;
    private int maxCharsRow;
    private int dropDownTableRow;
    private int defaultValueRow;
    private boolean hasFillType = false;
    private boolean hasValidation = false;
    private boolean hasDropDownTable = false;
    private boolean hasDefaultValueRow = false;
    private ButtonWidget saveButton;
    private TypedListBoxWidget<Long> fillTypeListBox = null;
    private final List<UiKeyName> fieldTypes = new ArrayList<UiKeyName>();
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final UserDefinedFieldListPanel parentPanel;
    private CustomListTable customListPanel = null;
    private GenericListTable frequencyListPanel = null;
    private CurrencyListTable currencyListPanel = null;
    private final DefaultValueWidgetFactory dvFactory = new DefaultValueWidgetFactory();

    public UserDefinedFieldDetailView(UserDefinedFieldListPanel parentPanel, final UiUserDefinedFieldRecord record, final DetailViewCallback<Long, UiUserDefinedFieldRecord> callback) {
        this.parentPanel = parentPanel;
        this.record = record;
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setStyleName(PANEL_STYLE);
        this.contractManagerDropDownService.getFieldTypeKeyNameList((AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                UserDefinedFieldDetailView.this.fieldTypes.addAll(result);
                UserDefinedFieldDetailView.this.initForm(record, (DetailViewCallback<Long, UiUserDefinedFieldRecord>)callback);
            }
        });
    }

    private void initForm(UiUserDefinedFieldRecord record, final DetailViewCallback<Long, UiUserDefinedFieldRecord> callback) {
        final UiUserDefinedField field = record.getUserDefinedField();
        this.nameTextBox.setText(field.getLabel());
        this.formContainer.addRow(this.constants.configurationNameColumn(), (Widget)this.nameTextBox, true);
        this.fieldTypeListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.fieldTypeListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

            public void onValueChange(ValueChangeEvent<Long> event) {
                int value = -1;
                if (event.getValue() != null) {
                    value = ((Long)event.getValue()).intValue();
                }
                if (UserDefinedFieldDetailView.this.hasDropDownTable) {
                    UserDefinedFieldDetailView.this.formContainer.removeRow(UserDefinedFieldDetailView.this.dropDownTableRow);
                    UserDefinedFieldDetailView.this.hasDropDownTable = false;
                }
                if (UserDefinedFieldDetailView.this.hasDefaultValueRow) {
                    UserDefinedFieldDetailView.this.formContainer.removeRow(UserDefinedFieldDetailView.this.defaultValueRow);
                    UserDefinedFieldDetailView.this.hasDefaultValueRow = false;
                }
                if (UserDefinedFieldDetailView.this.hasValidation) {
                    UserDefinedFieldDetailView.this.removeValidationRows();
                }
                if (UserDefinedFieldDetailView.this.hasFillType) {
                    UserDefinedFieldDetailView.this.formContainer.removeRow(UserDefinedFieldDetailView.this.fillTypeRow);
                    UserDefinedFieldDetailView.this.hasFillType = false;
                }
                if (value == FieldTypeEnum.Alphanumeric.ordinal() || value == FieldTypeEnum.Text.ordinal()) {
                    UserDefinedFieldDetailView.this.addFillTypeRow(field.getIdUserDefinedField() != null);
                    UserDefinedFieldDetailView.this.addValidationRows();
                } else if (value == FieldTypeEnum.Frequency.ordinal() || value == FieldTypeEnum.Currency.ordinal()) {
                    UserDefinedFieldDetailView.this.addFillTypeRow(field.getIdUserDefinedField() != null);
                    if (UserDefinedFieldDetailView.this.fillTypeListBox != null) {
                        UserDefinedFieldDetailView.this.fillTypeListBox.setValue((Object)1L);
                        UserDefinedFieldDetailView.this.fillTypeListBox.setEnabled(false);
                    }
                }
                if (value >= 0) {
                    UserDefinedFieldDetailView.this.addDropDownTable(FieldTypeEnum.values()[value]);
                }
            }
        });
        this.fieldTypeListBox.addItem("", null);
        for (UiKeyName keyName : this.fieldTypes) {
            this.fieldTypeListBox.addItem(keyName.getName(), (Object)keyName.getKey());
        }
        if (field.getType() != null) {
            this.fieldTypeListBox.setValue((Object)field.getType().ordinal());
        }
        if (field.getIdUserDefinedField() != null) {
            this.fieldTypeListBox.setEnabled(false);
        }
        this.formContainer.addRow(this.constants.configurationFieldTypeColumn(), (Widget)this.fieldTypeListBox, true);
        this.requiredYes = new RadioButtonWidget("required", this.constants.yes());
        this.requiredNo = new RadioButtonWidget("required", this.constants.no());
        boolean req = field.isRequired() != null ? field.isRequired() : false;
        HorizontalContainer requiredContainer = this.createRadioContainer(this.requiredYes, this.requiredNo, req ? this.requiredYes : this.requiredNo);
        this.formContainer.addRow(this.constants.configurationRequiredColumn(), (Widget)requiredContainer);
        this.orderTextBox = new TypedTextBoxWidget((IValueConverter)new PositiveIntegerConverter());
        this.orderTextBox.setValue((Object)field.getOrder());
        this.orderTextBox.setErrorToolTip(this.messages.positiveNumberValidationErrorTooltip());
        this.formContainer.addRow(this.constants.configurationOrderColumn(), (Widget)this.orderTextBox);
        if (FieldTypeEnum.Alphanumeric.equals((Object)field.getType()) || FieldTypeEnum.Text.equals((Object)field.getType())) {
            this.addFillTypeRow(field.getIdUserDefinedField() != null);
            if (field.isDropDown().booleanValue()) {
                if (this.fillTypeListBox != null) {
                    this.fillTypeListBox.setValue((Object)1L);
                }
            } else if (this.fillTypeListBox != null) {
                this.fillTypeListBox.setValue((Object)0L);
                this.addValidationRows();
            }
        } else if (FieldTypeEnum.Currency.equals((Object)field.getType()) || FieldTypeEnum.Frequency.equals((Object)field.getType())) {
            this.addFillTypeRow(field.getIdUserDefinedField() != null);
            if (this.fillTypeListBox != null) {
                this.fillTypeListBox.setValue((Object)1L);
                this.fillTypeListBox.setEnabled(false);
            }
        }
        if (field.isDropDown() != null && field.isDropDown().booleanValue()) {
            if (this.fillTypeListBox != null) {
                this.fillTypeListBox.setValue((Object)1L);
            }
            this.addDropDownTable(field.getType());
        } else {
            this.defaultValueWidget = this.dvFactory.createDefaultValueWidget(field.getType() == null ? FieldTypeEnum.Text : field.getType(), this.fillTypeListBox == null ? false : (Long)this.fillTypeListBox.getValue() == 1L, null, null, field.getMaxChars() == null ? 50 : field.getMaxChars());
            if (field.getDefaultValue() != null) {
                this.defaultValueWidget.setTextValue(field.getDefaultValue());
            }
            if (this.defaultValueWidget instanceof TypedTextBoxWidget) {
                ((TypedTextBoxWidget)this.defaultValueWidget).setMaxLength(50);
            }
            this.defaultValueRow = this.formContainer.addRow(this.constants.configurationDefaultValueColumn(), (Widget)this.defaultValueWidget);
            this.hasDefaultValueRow = true;
        }
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserDefinedFieldDetailView.this.parentPanel.clearMessages();
                ArrayList<String> validationMessages = new ArrayList<String>();
                validationMessages.add("User defined field has errors - hover over highlighted fields to identify and correct.");
                boolean isFormValid = UserDefinedFieldDetailView.this.formContainer.validate();
                boolean isDefaultValueValid = UserDefinedFieldDetailView.this.validateDefaultValue(validationMessages);
                if (isFormValid && isDefaultValueValid) {
                    callback.save((DetailView)UserDefinedFieldDetailView.this);
                } else {
                    for (String message : validationMessages) {
                        UserDefinedFieldDetailView.this.parentPanel.getErrorPanel().addMessage(message);
                    }
                }
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.formContainer.addButton(this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserDefinedFieldDetailView.this.parentPanel.clearMessages();
                callback.cancel((DetailView)UserDefinedFieldDetailView.this);
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.formContainer.addButton(cancelButton);
        this.formContainer.AddButtonPanelStyleName("cms_button_container");
        this.updateWidgetsAccess();
    }

    private void addDefaultValueRow(FieldTypeEnum fieldType, List<UiKeyName> uiKeyNamesList) {
        boolean isDropDown = this.fillTypeListBox == null ? false : (Long)this.fillTypeListBox.getValue() == 1L;
        this.defaultValueWidget = this.dvFactory.createDefaultValueWidget(fieldType, isDropDown, uiKeyNamesList, this.record.getUserDefinedField().getDefaultValue(), null);
        if (this.defaultValueWidget instanceof TypedTextBoxWidget) {
            ((TypedTextBoxWidget)this.defaultValueWidget).setMaxLength(50);
        }
        HorizontalContainer defaultRow = new HorizontalContainer();
        defaultRow.add(this.defaultValueWidget);
        if (isDropDown && !FieldTypeEnum.Date.equals((Object)fieldType) && !FieldTypeEnum.Number.equals((Object)fieldType) && !FieldTypeEnum.Percentage.equals((Object)fieldType)) {
            this.addSpace(defaultRow);
            defaultRow.add((Widget)new HelpWidget(this.messages.dropDownSelectionAfterSave()));
        }
        defaultRow.addStyleName("nwt-FormContainer-value-default-value");
        this.defaultValueRow = this.formContainer.addRow(this.constants.configurationDefaultValueColumn(), (Widget)defaultRow);
        this.hasDefaultValueRow = true;
    }

    private void addSpace(HorizontalContainer container) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add((Widget)label);
            space.setCellWidth((Widget)label, "10");
            container.add((Widget)space);
        }
    }

    private void addDropDownTable(final FieldTypeEnum type) {
        final ArrayList<UiKeyName> uiKeyNamesList = new ArrayList<UiKeyName>();
        final BusyIndicator busyIndicator = new BusyIndicator();
        if (FieldTypeEnum.Frequency.equals((Object)type)) {
            this.frequencyListPanel = new GenericListTable(this.constants.frequency(), this.constants.frequency(), true);
            this.frequencyListPanel.createTable();
            busyIndicator.center();
            this.contractManagerDropDownService.getGenericDropDownKeyNameList(0, 0, null, true, ConfigurableFieldTypeEnum.Frequency, (AsyncCallback<UiKeyNames>)new NeptuneAsyncCallback<UiKeyNames>(){

                public void onNeptuneFailure(Throwable caught) {
                    busyIndicator.hide();
                    UserDefinedFieldDetailView.this.replaceDefaultValueRow(type, uiKeyNamesList);
                    UserDefinedFieldDetailView.this.addFrequencyList();
                }

                public void onNeptuneSuccess(UiKeyNames result) {
                    uiKeyNamesList.addAll(result.getRecords());
                    UserDefinedFieldDetailView.this.frequencyListPanel.setRecordList(result.getRecords());
                    busyIndicator.hide();
                    UserDefinedFieldDetailView.this.replaceDefaultValueRow(type, uiKeyNamesList);
                    UserDefinedFieldDetailView.this.addFrequencyList();
                }
            });
        } else if (FieldTypeEnum.Currency.equals((Object)type)) {
            this.currencyListPanel = new CurrencyListTable(this.constants.currencyTableHeader(), this.constants.currency(), true);
            this.currencyListPanel.createTable();
            busyIndicator.center();
            this.contractManagerDropDownService.getCurrencies((AsyncCallback<List<UiCurrency>>)new NeptuneAsyncCallback<List<UiCurrency>>(){

                public void onNeptuneFailure(Throwable caught) {
                    busyIndicator.hide();
                    UserDefinedFieldDetailView.this.replaceDefaultValueRow(type, uiKeyNamesList);
                    UserDefinedFieldDetailView.this.addCurrencyList();
                }

                public void onNeptuneSuccess(List<UiCurrency> result) {
                    for (UiCurrency currency : result) {
                        UiKeyName keyName = new UiKeyName(currency.getKey());
                        keyName.setName(String.valueOf(currency.getName()) + " (" + currency.getSymbol() + ")");
                        uiKeyNamesList.add(keyName);
                    }
                    busyIndicator.hide();
                    UserDefinedFieldDetailView.this.replaceDefaultValueRow(type, uiKeyNamesList);
                    UserDefinedFieldDetailView.this.currencyListPanel.setRecordList(result);
                    UserDefinedFieldDetailView.this.addCurrencyList();
                }
            });
        } else if ((FieldTypeEnum.Alphanumeric.equals((Object)type) || FieldTypeEnum.Text.equals((Object)type)) && this.fillTypeListBox != null && (Long)this.fillTypeListBox.getValue() == 1L) {
            uiKeyNamesList.addAll(this.record.getUserDefinedField().getKeyNames());
            this.customListPanel = new CustomListTable(uiKeyNamesList, this.constants.dropDownListHeading(), this.constants.recordDisplayName());
            this.customListPanel.createTable();
            this.addDefaultValueRow(type, uiKeyNamesList);
            this.dropDownTableRow = this.formContainer.addRow("", (Widget)this.customListPanel);
            this.hasDropDownTable = true;
        } else {
            this.addDefaultValueRow(type, null);
        }
    }

    private void replaceDefaultValueRow(FieldTypeEnum type, List<UiKeyName> uiKeyNamesList) {
        if (this.hasDefaultValueRow) {
            this.formContainer.removeRow(this.defaultValueRow);
            this.hasDefaultValueRow = false;
        }
        this.addDefaultValueRow(type, uiKeyNamesList);
    }

    private void addFrequencyList() {
        this.dropDownTableRow = this.formContainer.addRow("", (Widget)this.frequencyListPanel);
        this.hasDropDownTable = true;
    }

    private void addCurrencyList() {
        this.dropDownTableRow = this.formContainer.addRow("", (Widget)this.currencyListPanel);
        this.hasDropDownTable = true;
    }

    private void addValidationRows() {
        this.minCharsTextBox = new TypedTextBoxWidget((IValueConverter)new PositiveIntegerConverter());
        Integer minChars = this.record.getUserDefinedField().getMinChars();
        if (minChars != null) {
            this.minCharsTextBox.setValue((Object)minChars);
        }
        this.minCharsTextBox.setErrorToolTip(this.messages.positiveNumberValidationErrorTooltip());
        this.minCharsRow = this.formContainer.addRow(this.constants.configurationMinCharsColumn(), (Widget)this.minCharsTextBox);
        this.maxCharsTextBox = new TypedTextBoxWidget((IValueConverter)new PositiveIntegerConverter(50));
        Integer maxChars = this.record.getUserDefinedField().getMaxChars();
        if (maxChars != null) {
            this.maxCharsTextBox.setValue((Object)maxChars);
        }
        this.maxCharsTextBox.setMaxLength(2);
        this.maxCharsTextBox.setErrorToolTip(this.messages.maxCharsValidationErrorTooltip(50));
        this.maxCharsRow = this.formContainer.addRow(this.constants.configurationMaxCharsColumn(), (Widget)this.maxCharsTextBox);
        this.hasValidation = true;
    }

    private void removeValidationRows() {
        this.formContainer.removeRow(this.maxCharsRow);
        this.formContainer.removeRow(this.minCharsRow);
        this.hasValidation = false;
    }

    private void addFillTypeRow(boolean isEditing) {
        this.fillTypeListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.fillTypeListBox.setEnabled(!isEditing);
        this.fillTypeListBox.addItem(this.constants.freeType(), (Object)0L);
        this.fillTypeListBox.addItem(this.constants.dropDown(), (Object)1L);
        this.fillTypeListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

            public void onValueChange(ValueChangeEvent<Long> event) {
                switch (((Long)event.getValue()).intValue()) {
                    case 0: {
                        if (UserDefinedFieldDetailView.this.hasDropDownTable) {
                            UserDefinedFieldDetailView.this.formContainer.removeRow(UserDefinedFieldDetailView.this.dropDownTableRow);
                            UserDefinedFieldDetailView.this.hasDropDownTable = false;
                            if (UserDefinedFieldDetailView.this.hasDefaultValueRow) {
                                UserDefinedFieldDetailView.this.formContainer.removeRow(UserDefinedFieldDetailView.this.defaultValueRow);
                                UserDefinedFieldDetailView.this.hasDefaultValueRow = false;
                            }
                        }
                        UserDefinedFieldDetailView.this.addValidationRows();
                        UserDefinedFieldDetailView.this.addDefaultValueRow(FieldTypeEnum.values()[((Long)UserDefinedFieldDetailView.this.fieldTypeListBox.getValue()).intValue()], null);
                        break;
                    }
                    case 1: {
                        if (UserDefinedFieldDetailView.this.hasDefaultValueRow) {
                            UserDefinedFieldDetailView.this.formContainer.removeRow(UserDefinedFieldDetailView.this.defaultValueRow);
                            UserDefinedFieldDetailView.this.hasDefaultValueRow = false;
                        }
                        UserDefinedFieldDetailView.this.removeValidationRows();
                        if (UserDefinedFieldDetailView.this.fieldTypeListBox.getValue() == null) break;
                        UserDefinedFieldDetailView.this.addDropDownTable(FieldTypeEnum.values()[((Long)UserDefinedFieldDetailView.this.fieldTypeListBox.getValue()).intValue()]);
                    }
                }
            }
        });
        this.fillTypeRow = this.formContainer.addRow(this.constants.configurationFillTypeColumn(), (Widget)this.fillTypeListBox);
        this.hasFillType = true;
    }

    private HorizontalContainer createRadioContainer(RadioButtonWidget radio1, RadioButtonWidget radio2, RadioButtonWidget requiredRadio) {
        HorizontalContainer container = new HorizontalContainer();
        container.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        container.addStyleName(REQUIRED_ROW_STYLE);
        container.add((Widget)radio1);
        HorizontalPanel space = new HorizontalPanel();
        LabelWidget label = new LabelWidget();
        space.add((Widget)label);
        space.setCellWidth((Widget)label, "10px");
        container.add((Widget)space);
        requiredRadio.setValue(Boolean.valueOf(true));
        container.add((Widget)radio2);
        return container;
    }

    private boolean validateDefaultValue(List<String> validationMessages) {
        String defaultString;
        boolean isValid = true;
        UiUserDefinedField field = this.updateUiUserdefinedField();
        CustomFieldValidator.validate(this.defaultValueWidget, field);
        if (!this.defaultValueWidget.isValidValue() || this.defaultValueWidget.hasValidationError()) {
            String tooltip = this.defaultValueWidget.getToolTip();
            if (tooltip == null) {
                tooltip = "";
            }
            validationMessages.add(String.valueOf(this.messages.invalidFieldValue(this.constants.configurationDefaultValueColumn())) + tooltip);
            isValid = false;
        }
        String string = defaultString = this.defaultValueWidget.getTextValue() != null ? this.defaultValueWidget.getTextValue().trim() : "";
        if (this.requiredYes.getValue().booleanValue() && defaultString.equals("")) {
            this.markRequiredError((Widget)this.defaultValueWidget);
            validationMessages.add(this.messages.defaultValueRequired());
            isValid = false;
        }
        if (defaultString != null && !defaultString.isEmpty()) {
            FieldTypeEnum type = FieldTypeEnum.values()[((Long)this.fieldTypeListBox.getValue()).intValue()];
            if (this.fieldTypeListBox != null) {
                switch (type) {
                    case Number: {
                        try {
                            Long.parseLong(defaultString);
                        }
                        catch (Exception exception) {
                            validationMessages.add(this.messages.defaultValueNotNumber(Long.MAX_VALUE));
                            isValid = false;
                        }
                        break;
                    }
                    case Percentage: {
                        try {
                            Float value = Float.valueOf(Float.parseFloat(defaultString));
                            if (!(value.floatValue() < 0.0f) && !(value.floatValue() > 100.0f)) break;
                            validationMessages.add(this.messages.defaultValueBetween0And100());
                            isValid = false;
                        }
                        catch (Exception exception) {
                            validationMessages.add(this.messages.defaultValueNotPercentage());
                            isValid = false;
                        }
                        break;
                    }
                    case Date: {
                        if (defaultString.isEmpty()) break;
                        DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)this.constants.dateFormat());
                        try {
                            dateFormatter.parseStrict(defaultString);
                            break;
                        }
                        catch (Exception exception) {
                            validationMessages.add(this.messages.defaultValueDateFormat(this.constants.dateFormat()));
                            isValid = false;
                        }
                    }
                }
            }
        }
        if (this.hasValidation) {
            int maxLength;
            int minLength = this.minCharsTextBox != null && this.minCharsTextBox.getText().trim().length() > 0 ? Integer.parseInt(this.minCharsTextBox.getText()) : 0;
            int n = maxLength = this.maxCharsTextBox != null && this.maxCharsTextBox.getText().trim().length() > 0 ? Integer.parseInt(this.maxCharsTextBox.getText()) : 50;
            if (maxLength < minLength || maxLength == 0) {
                validationMessages.add(this.messages.maxGreaterThanMin(maxLength, minLength));
                isValid = false;
            } else {
                if (defaultString.length() < minLength) {
                    validationMessages.add(this.messages.defaultValueMinLength(minLength));
                    isValid = false;
                }
                if (defaultString.length() > maxLength) {
                    validationMessages.add(this.messages.defaultValueMaxLength(maxLength));
                    isValid = false;
                }
            }
        } else if (defaultString.length() > 50) {
            validationMessages.add(this.messages.defaultValueMaxLength(50));
            isValid = false;
        }
        return isValid;
    }

    private void markRequiredError(Widget widget) {
        if (widget instanceof DataTypeWidget) {
            DataTypeWidget dataTypeWidget = (DataTypeWidget)widget;
            if (dataTypeWidget.isValidValue()) {
                dataTypeWidget.showValidationError(this.messages.fieldRequiredValidationErrorTooltip());
            }
        } else {
            widget.addStyleDependentName(ERROR_STYLE);
            widget.setTitle(this.messages.fieldRequiredValidationErrorTooltip());
        }
    }

    private void updateWidgetsAccess() {
        boolean isCreating = this.record.getKey() == null;
        this.nameTextBox.setReadOnly(!isCreating);
        this.saveButton.setVisible(this.saveButtonIsVisible(isCreating));
    }

    private boolean saveButtonIsVisible(boolean isCreating) {
        boolean visible = isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        return visible;
    }

    public void commit() {
        UiUserDefinedField f = this.updateUiUserdefinedField();
        this.record.setUserDefinedField(f);
        if (FieldTypeEnum.Currency.equals((Object)this.record.getUserDefinedField().getType())) {
            List<UiCurrency> currencyList = this.currencyListPanel.getCollapsedRecordList();
            this.contractManagerDropDownService.saveCurrencyList(currencyList, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneSuccess(Void v) {
                }

                public void onNeptuneFailure(Throwable t) {
                    UserDefinedFieldDetailView.this.saveFailed(t);
                }
            });
        } else if (FieldTypeEnum.Frequency.equals((Object)this.record.getUserDefinedField().getType())) {
            List<UiKeyName> keyList = this.frequencyListPanel.getCollapsedRecordList();
            this.contractManagerDropDownService.saveGenericDropDownKeyList(keyList, ConfigurableFieldTypeEnum.Frequency, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneSuccess(Void v) {
                    UserDefinedFieldDetailView.this.parentPanel.getSuccessPanel().showMessage("SUCCESS!");
                }

                public void onNeptuneFailure(Throwable t) {
                    UserDefinedFieldDetailView.this.saveFailed(t);
                }
            });
        } else if ((FieldTypeEnum.Alphanumeric.equals((Object)this.record.getUserDefinedField().getType()) || FieldTypeEnum.Text.equals((Object)this.record.getUserDefinedField().getType())) && this.customListPanel != null) {
            List<UiKeyName> keyList = this.customListPanel.getCollapsedRecordList();
            HashSet<UiKeyName> keySet = new HashSet<UiKeyName>(keyList);
            this.record.getUserDefinedField().setKeyNames(keySet);
        }
    }

    private UiUserDefinedField updateUiUserdefinedField() {
        UiUserDefinedField f = this.record.getUserDefinedField();
        f.setLabel(this.nameTextBox.getText().trim());
        f.setType(FieldTypeEnum.values()[((Long)this.fieldTypeListBox.getValue()).intValue()]);
        f.setRequired(this.requiredYes.getValue());
        f.setDefaultValue(this.defaultValueWidget.getTextValue() != null ? this.defaultValueWidget.getTextValue().trim() : null);
        f.setOrder(this.orderTextBox.getText() != null && this.orderTextBox.getText().trim().length() > 0 ? Integer.valueOf(this.orderTextBox.getText()) : 1);
        f.setDropDown(this.fillTypeListBox != null ? (Long)this.fillTypeListBox.getValue() == 1L : false);
        f.setMaxChars(this.maxCharsTextBox != null && this.maxCharsTextBox.getText().trim().length() > 0 ? Integer.valueOf(this.maxCharsTextBox.getText()) : null);
        f.setMinChars(this.minCharsTextBox != null && this.minCharsTextBox.getText().trim().length() > 0 ? Integer.valueOf(this.minCharsTextBox.getText()) : null);
        if (this.hasDropDownTable) {
            if (this.customListPanel != null) {
                HashSet<UiKeyName> keySet = new HashSet<UiKeyName>(this.customListPanel.getRecords());
                f.setKeyNames(keySet);
            } else {
                f.setKeyNames(null);
            }
        }
        return f;
    }

    public UiUserDefinedFieldRecord getRecord() {
        return this.record;
    }

    public void revert() {
        this.updateWidgetsAccess();
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        this.mainContainer.add((Widget)this.formContainer);
        return this.mainContainer;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            for (String message : ve.getValidationMessages()) {
                this.parentPanel.getErrorPanel().addMessage(message);
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage(throwable.getLocalizedMessage());
        }
    }

    protected void onUnload() {
        super.onUnload();
    }
}

