/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.ConfigurationAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.config.ConfigurationDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.UiUserDefinedFieldRecord;
import com.ericsson.cms.contractmgmt.client.tab.config.UserDefinedFieldDetailFeature;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class UserDefinedFieldListPanel
extends Composite {
    private static final String TABLE_STYLE = "configuration-panel";
    private final String screenName;
    private ConfigurationDataProvider dataProvider;
    private SortFeatureImpl<Long, UiUserDefinedFieldRecord> sortFeature;
    private UserDefinedFieldDetailFeature detailFeature;
    private BookmarkFeature bookmarkFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<Long, UiUserDefinedFieldRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();

    public UserDefinedFieldListPanel(String screenName) {
        this.screenName = screenName;
        this.dataProvider = new ConfigurationDataProvider(screenName);
        this.dataProvider.setBusyNotifier(new ConfigurationDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                UserDefinedFieldListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                UserDefinedFieldListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.setStyleName(TABLE_STYLE);
        this.sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiUserDefinedFieldRecord> col : this.dataProvider.getSortColumns()) {
            this.sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature(this.sortFeature);
        this.detailFeature = new UserDefinedFieldDetailFeature(this, this.screenName);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.table.addSortFeature(this.sortFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
        this.anchorChangeListener = new ConfigurationAnchorChangeListener(this);
    }

    public Table<Long, UiUserDefinedFieldRecord> getUserDefinedFieldsTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }
}

