/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public abstract class ConfigurableFieldDataProvider
implements DataProvider<Long, UiKeyNameRecord> {
    private final List<Column<?, UiKeyNameRecord>> columns;
    private final ColumnBase<String, UiKeyNameRecord> nameColumn;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    protected List<UiKeyNameRecord> keyNameRecords = new ArrayList<UiKeyNameRecord>();
    private static String FIELD_NAME_COLUMN = "fieldName";
    private IBusyNotifier busyNotifier;

    public ConfigurableFieldDataProvider() {
        this.columns = new ArrayList();
        this.nameColumn = new ColumnBase<String, UiKeyNameRecord>(FIELD_NAME_COLUMN, this.constants.configurationFieldNameColumn()){

            public View<String> getView(UiKeyNameRecord record) {
                return new LabelStringView(record.getKeyName().getName());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiKeyNameRecord>)this.nameColumn);
    }

    public ColumnBase<String, UiKeyNameRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiKeyNameRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiKeyNameRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<UiKeyNameRecord> callback) {
        for (UiKeyNameRecord record : this.keyNameRecords) {
            if (!record.getKey().equals(key)) continue;
            callback.onSuccess((Object)record);
            break;
        }
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return false;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    protected void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    protected void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

