/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider.ContentProviderMainDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyMainDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.DeviceMainDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericMainDetailView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.List;

public class ConfigurableFieldDetailFeature
extends AbstractDetailFeature<Long, UiKeyNameRecord> {
    ConfigurableFieldListPanel parentPanel;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);

    public ConfigurableFieldDetailFeature() {
        super((KeySerializer)new UiLongKeySerializer());
    }

    public ConfigurableFieldDetailFeature(ConfigurableFieldListPanel parentPanel) {
        this();
        this.parentPanel = parentPanel;
    }

    public void getNew(AsyncCallback<UiKeyNameRecord> callback) {
    }

    public boolean hasDetailLink(Column<?, UiKeyNameRecord> column) {
        return column.getDisplayName().equals(this.constants.configurationFieldNameColumn()) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
    }

    public boolean showCreateButton() {
        return false;
    }

    public boolean showDeleteButton() {
        return false;
    }

    public DetailView<Long, UiKeyNameRecord> getView(UiKeyNameRecord record, DetailViewCallback<Long, UiKeyNameRecord> callback) {
        ConfigurableFieldDetailView detailView = null;
        if (record != null) {
            ConfigurableFieldTypeEnum fieldType = ConfigurableFieldTypeEnum.values()[record.getKey().intValue()];
            if (fieldType.isGeneric()) {
                detailView = new GenericMainDetailView(fieldType, record, callback);
            } else if (ConfigurableFieldTypeEnum.Device.equals((Object)fieldType)) {
                detailView = new DeviceMainDetailView(record, callback, this.parentPanel);
            } else if (ConfigurableFieldTypeEnum.Currency.equals((Object)fieldType)) {
                detailView = new CurrencyMainDetailView(record, callback, this.parentPanel);
            } else if (ConfigurableFieldTypeEnum.ContentProvider.equals((Object)fieldType)) {
                detailView = new ContentProviderMainDetailView(record, callback);
            }
        }
        return detailView;
    }

    public void save(UiKeyNameRecord record, AsyncCallback<Void> callback) {
    }

    public void delete(List<UiKeyNameRecord> records, AsyncCallback<Void> callback) {
    }
}

