/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldDetailFeature;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ConfigurableFieldListPanel
extends Composite {
    private ConfigurableFieldDataProvider dataProvider;
    private ConfigurableFieldDetailFeature detailFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<Long, UiKeyNameRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SuccessPanel successPanel;
    private ErrorPanel errorPanel;
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";
    private static final String TABLE_STYLE = "configuration-panel";

    public ConfigurableFieldListPanel(ConfigurableFieldDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        dataProvider.setBusyNotifier(new ConfigurableFieldDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                ConfigurableFieldListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                ConfigurableFieldListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.mainContainer.setWidth("100%");
        this.initWidget((Widget)this.mainContainer);
        this.successPanel = new SuccessPanel();
        this.mainContainer.add((Widget)this.successPanel);
        this.errorPanel = new ErrorPanel();
        this.mainContainer.add((Widget)this.errorPanel);
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.setStyleName(TABLE_STYLE);
        this.detailFeature = new ConfigurableFieldDetailFeature(this);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
                ConfigurableFieldListPanel.this.table.refresh();
            }
        });
        this.anchorChangeListener = new ConfigurableFieldAnchorChangeListener(this);
    }

    public Table<Long, UiKeyNameRecord> getTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }
}

