/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public abstract class DropDownDataProvider<Record extends UiKeyNameRecord>
implements DataProvider<Long, Record> {
    protected final List<Column<?, Record>> columns;
    private final ColumnBase<String, Record> nameColumn;
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, Record> parentSortFeature;
    protected ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    protected List<Record> records = new ArrayList<Record>();
    private static String NAME_COLUMN = "name";
    private IBusyNotifier busyNotifier;

    public DropDownDataProvider() {
        this.columns = new ArrayList();
        this.nameColumn = new ColumnBase<String, Record>(NAME_COLUMN, this.constants.configurationDropDownNameColumn()){

            public View<String> getView(Record record) {
                return new LabelStringView(((UiKeyNameRecord)record).getKeyName().getName());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, Record>)this.nameColumn);
    }

    public ColumnBase<String, Record> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, Record>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, Record>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<Record> callback) {
        for (UiKeyNameRecord record : this.records) {
            if (!record.getKey().equals(key)) continue;
            callback.onSuccess((Object)record);
            break;
        }
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    protected void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    protected void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, Record> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, Record> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

