/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.DefaultValueWidgetFactory;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

public class DropDownDetailView
extends Composite
implements DetailView<Long, UiKeyNameRecord> {
    private final UiKeyNameRecord record;
    private final DetailViewCallback<Long, UiKeyNameRecord> callback;
    private final VerticalContainer mainContainer;
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private static final int MAX_LENGTH = 50;
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private DataTypeWidget<?> nameTextBox = null;
    private ButtonWidget saveButton;
    private final boolean parentModifying;
    private FieldTypeEnum fieldType = FieldTypeEnum.Text;
    private final DefaultValueWidgetFactory dvFactory = new DefaultValueWidgetFactory();

    public DropDownDetailView(UiKeyNameRecord record, DetailViewCallback<Long, UiKeyNameRecord> callback, boolean parentModifying, FieldTypeEnum type) {
        this.record = record;
        this.callback = callback;
        this.parentModifying = parentModifying;
        if (type != null) {
            this.fieldType = type;
        }
        this.mainContainer = new VerticalContainer();
        this.initForm();
    }

    private void initForm() {
        this.nameTextBox = this.dvFactory.createTextField(this.record.getKeyName().getName(), false, 50, this.fieldType);
        this.nameTextBox.ensureDebugId("license-" + this.fieldType.getType());
        this.formContainer.addRow(this.constants.configurationNameColumn(), (Widget)this.nameTextBox, true);
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DropDownDetailView.this.errorPanel.reset();
                if (DropDownDetailView.this.formContainer.validate()) {
                    DropDownDetailView.this.callback.save((DetailView)DropDownDetailView.this);
                }
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.ensureDebugId("configuration-save");
        this.formContainer.addButton(this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DropDownDetailView.this.errorPanel.reset();
                DropDownDetailView.this.callback.cancel((DetailView)DropDownDetailView.this);
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.formContainer.addButton(cancelButton);
        this.formContainer.AddButtonPanelStyleName("cms_button_container");
        this.updateWidgetsAccess();
    }

    private void updateWidgetsAccess() {
        boolean isCreating = this.record.getKey() == null;
        this.saveButton.setVisible(this.saveButtonIsVisible(isCreating));
    }

    private boolean saveButtonIsVisible(boolean isCreating) {
        boolean visible = isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) || this.parentModifying && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        return visible;
    }

    public void commit() {
        this.record.getKeyName().setName(this.nameTextBox.getTextValue().trim());
    }

    public UiKeyNameRecord getRecord() {
        return this.record;
    }

    public void revert() {
        this.updateWidgetsAccess();
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add((Widget)this.formContainer);
        return this.mainContainer;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            for (String message : ve.getValidationMessages()) {
                this.errorPanel.addMessage(message);
            }
        } else {
            this.errorPanel.showMessage(throwable.getLocalizedMessage());
        }
    }

    protected void onUnload() {
        super.onUnload();
    }
}

