/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public abstract class DropDownListPanel<Record extends UiKeyNameRecord>
extends Composite {
    private DropDownDataProvider<Record> dataProvider;
    private DropDownDetailFeature<Record> detailFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private boolean hasPageFeature;
    private boolean hasSortFeature;
    private VerticalContainer mainContainer;
    private Table<Long, Record> table;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    protected ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    protected Long userDefinedFieldId;
    private boolean editing = false;
    protected FieldTypeEnum type = FieldTypeEnum.Text;
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";

    public DropDownListPanel(boolean hasPageFeature, boolean hasSortFeature) {
        this.hasPageFeature = hasPageFeature;
        this.hasSortFeature = hasSortFeature;
        this.init();
    }

    public DropDownListPanel(boolean hasPageFeature, boolean hasSortFeature, Long userDefinedFieldId, FieldTypeEnum type) {
        this.hasPageFeature = hasPageFeature;
        this.hasSortFeature = hasSortFeature;
        this.userDefinedFieldId = userDefinedFieldId;
        boolean bl = this.editing = userDefinedFieldId != null;
        if (type != null) {
            this.type = type;
        }
        this.init();
    }

    private void init() {
        this.dataProvider = this.getDataProvider();
        this.dataProvider.setBusyNotifier(new DropDownDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                DropDownListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                DropDownListPanel.this.busyIndicator.hide();
            }
        });
        this.initWidgets();
        this.setContainers();
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.table = new Table(this.dataProvider);
        this.table.addTableViewChangeHandler(new TableViewChangeHandler<Long, Record>(){

            public void onShowDetailView(TableDetailViewEvent<Long, Record> event) {
                if (event.isCreateView()) {
                    DropDownListPanel.this.header.setLabel(DropDownListPanel.this.getCreateHeading());
                } else {
                    DropDownListPanel.this.header.setLabel(String.valueOf(DropDownListPanel.this.getEditHeading()) + " " + ((UiKeyNameRecord)event.getRecord()).getKeyName().getName());
                }
            }

            public void onShowListView(TableViewEvent event) {
                DropDownListPanel.this.header.setLabel(DropDownListPanel.this.getListHeading());
            }
        });
        this.detailFeature = this.getDropDownDetailFeature();
        if (this.hasPageFeature) {
            PageFeatureImpl pageFeature = new PageFeatureImpl();
            this.dataProvider.setParentPageFeature((PageFeature)pageFeature);
            this.table.addPageFeature((PageFeature)pageFeature);
        }
        if (this.hasSortFeature) {
            SortFeatureImpl sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
            this.dataProvider.setParentSortFeature(sortFeature);
            for (Column<?, Record> col : this.dataProvider.getSortColumns()) {
                sortFeature.addSortableColumn(col);
            }
            this.dataProvider.setParentSortFeature(sortFeature);
        }
        this.table.addDetailFeature(this.detailFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
                DropDownListPanel.this.table.refresh();
            }
        });
        this.anchorChangeListener = new DropDownAnchorChangeListener(this);
    }

    protected abstract DropDownDataProvider<Record> getDataProvider();

    protected abstract DropDownDetailFeature<Record> getDropDownDetailFeature();

    public String getCreateHeading() {
        return this.constants.dropDownCreateHeading();
    }

    public String getEditHeading() {
        return this.constants.dropDownViewEditHeading();
    }

    public String getListHeading() {
        return this.constants.dropDownListHeading();
    }

    public Table<Long, Record> getTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }
}

