/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider.UiContentProviderRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ContentProviderDetailView
extends Composite
implements DetailView<Long, UiContentProviderRecord> {
    private static final String STYLE_VALIDATION_MESSAGE = "contract-failure-message";
    private UiContentProviderRecord record;
    private DetailViewCallback<Long, UiContentProviderRecord> callback;
    private VerticalContainer mainContainer;
    private final LabelWidget errorMessageLabel = new LabelWidget();
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private TextBoxWidget nameTextBox = new TextBoxWidget();
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);

    public ContentProviderDetailView(UiContentProviderRecord record, DetailViewCallback<Long, UiContentProviderRecord> callback) {
        this.record = record;
        this.callback = callback;
        this.mainContainer = new VerticalContainer();
        this.errorMessageLabel.setStyleName(STYLE_VALIDATION_MESSAGE);
        this.initForm();
    }

    private void initForm() {
        this.nameTextBox.setText(this.record.getContentProvider().getName());
        this.formContainer.addRow(this.constants.configurationNameColumn(), (Widget)this.nameTextBox, true);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ContentProviderDetailView.this.errorMessageLabel.setText(null);
                ContentProviderDetailView.this.callback.cancel((DetailView)ContentProviderDetailView.this);
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.formContainer.addButton(cancelButton);
    }

    public void commit() {
        this.record.getContentProvider().setName(this.nameTextBox.getText());
    }

    public UiContentProviderRecord getRecord() {
        return this.record;
    }

    public void revert() {
        this.nameTextBox.setText(this.record.getContentProvider().getName());
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        this.mainContainer.add((Widget)this.errorMessageLabel);
        this.mainContainer.add((Widget)this.formContainer);
        return this.mainContainer;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
    }

    protected void onUnload() {
        super.onUnload();
    }
}

