/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.UiCurrencyRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.List;

public class CurrencyDataProvider
extends DropDownDataProvider<UiCurrencyRecord> {
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final ColumnBase<String, UiCurrencyRecord> symbolColumn = new ColumnBase<String, UiCurrencyRecord>(SYMBOL_COLUMN, this.constants.currencySymbolColumn()){

        public View<String> getView(UiCurrencyRecord record) {
            return new LabelStringView(record.getCurrency().getSymbol());
        }
    };
    private static String SYMBOL_COLUMN = "symbol";

    public CurrencyDataProvider() {
        this.symbolColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add(this.symbolColumn);
    }

    public void getRecords(final AsyncCallback<List<UiCurrencyRecord>> callback) {
        this.notifyBusyStart();
        this.contractManagerDropDownService.getCurrencies((AsyncCallback<List<UiCurrency>>)new NeptuneAsyncCallback<List<UiCurrency>>(){

            public void onNeptuneFailure(Throwable caught) {
                CurrencyDataProvider.this.notifyBusyFinish();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(List<UiCurrency> result) {
                CurrencyDataProvider.this.records.clear();
                for (UiCurrency currency : result) {
                    CurrencyDataProvider.this.records.add(new UiCurrencyRecord(currency));
                }
                CurrencyDataProvider.this.notifyBusyFinish();
                callback.onSuccess((Object)CurrencyDataProvider.this.records);
            }
        });
    }
}

