/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.UiCurrencyRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import java.util.ArrayList;
import java.util.List;

public class CurrencyDetailFeature
extends DropDownDetailFeature<UiCurrencyRecord> {
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private CurrencyListPanel parentPanel;

    public CurrencyDetailFeature(CurrencyListPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiCurrencyRecord> records, final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (Window.confirm((String)this.messages.deleteGenericConfirmation(ConfigurableFieldTypeEnum.Currency.getDisplayName()))) {
                ArrayList<UiCurrency> currencies = new ArrayList<UiCurrency>();
                for (UiCurrencyRecord record : records) {
                    currencies.add(record.getCurrency());
                }
                this.contractManagerDropDownService.deleteCurrencies(currencies, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        CurrencyDetailFeature.this.parentPanel.getTable().refresh();
                        CurrencyDetailFeature.this.parentPanel.getErrorPanel().showMessage(String.valueOf(CurrencyDetailFeature.this.messages.deleteGenericError()) + " " + ConfigurableFieldTypeEnum.Currency.getDisplayName());
                        if (caught instanceof ValidationException) {
                            ValidationException ve = (ValidationException)caught;
                            for (String message : ve.getValidationMessages()) {
                                CurrencyDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                            }
                        } else {
                            callback.onFailure(caught);
                        }
                    }

                    public void onNeptuneSuccess(Void result) {
                        CurrencyDetailFeature.this.parentPanel.getSuccessPanel().showMessage(String.valueOf(ConfigurableFieldTypeEnum.Currency.getDisplayName()) + " " + CurrencyDetailFeature.this.messages.deleteGenericSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)(String.valueOf(this.messages.noGenericSelected()) + " " + ConfigurableFieldTypeEnum.Currency.getDisplayName()));
        }
    }

    public void getNew(AsyncCallback<UiCurrencyRecord> callback) {
        this.parentPanel.clearMessages();
        callback.onSuccess((Object)new UiCurrencyRecord(new UiCurrency()));
    }

    public DetailView<Long, UiCurrencyRecord> getView(UiCurrencyRecord record, DetailViewCallback<Long, UiCurrencyRecord> callback) {
        this.parentPanel.clearMessages();
        CurrencyDetailView view = new CurrencyDetailView(this.parentPanel, record, callback);
        return view;
    }

    public void save(UiCurrencyRecord record, final AsyncCallback<Void> callback) {
        this.contractManagerDropDownService.saveCurrency(record.getCurrency(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                CurrencyDetailFeature.this.parentPanel.getErrorPanel().showMessage(String.valueOf(CurrencyDetailFeature.this.messages.saveGenericError()) + " " + ConfigurableFieldTypeEnum.Currency.getDisplayName());
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Void result) {
                CurrencyDetailFeature.this.parentPanel.getSuccessPanel().showMessage(String.valueOf(ConfigurableFieldTypeEnum.Currency.getDisplayName()) + " " + CurrencyDetailFeature.this.messages.saveGenericSucceeded());
                callback.onSuccess(null);
            }
        });
    }

    @Override
    public boolean showCreateButton() {
        if (this.parentPanel.isModifying()) {
            return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        }
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
    }

    @Override
    public boolean showDeleteButton() {
        if (this.parentPanel.isModifying()) {
            return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        }
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
    }
}

