/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.UiCurrencyRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class CurrencyDetailView
extends Composite
implements DetailView<Long, UiCurrencyRecord> {
    private final UiCurrencyRecord record;
    private final DetailViewCallback<Long, UiCurrencyRecord> callback;
    private final VerticalContainer mainContainer;
    private static final int MAX_LENGTH = 50;
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private final TextBoxWidget nameTextBox = new TextBoxWidget();
    private final TextBoxWidget symbolTextBox = new TextBoxWidget();
    private ButtonWidget saveButton;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final CurrencyListPanel parentPanel;

    public CurrencyDetailView(CurrencyListPanel parentPanel, UiCurrencyRecord record, DetailViewCallback<Long, UiCurrencyRecord> callback) {
        this.record = record;
        this.callback = callback;
        this.parentPanel = parentPanel;
        this.mainContainer = new VerticalContainer();
        this.initForm();
        this.updateWidgetsAccess();
    }

    private void initForm() {
        this.nameTextBox.setMaxLength(50);
        this.nameTextBox.setText(this.record.getKeyName().getName());
        this.formContainer.addRow(this.constants.configurationNameColumn(), (Widget)this.nameTextBox, true);
        this.symbolTextBox.setMaxLength(50);
        this.symbolTextBox.setText(this.record.getCurrency().getSymbol());
        this.formContainer.addRow(this.constants.currencySymbolColumn(), (Widget)this.symbolTextBox, true);
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurrencyDetailView.this.parentPanel.clearMessages();
                if (CurrencyDetailView.this.formContainer.validate()) {
                    CurrencyDetailView.this.callback.save((DetailView)CurrencyDetailView.this);
                }
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.formContainer.addButton(this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurrencyDetailView.this.parentPanel.clearMessages();
                CurrencyDetailView.this.callback.cancel((DetailView)CurrencyDetailView.this);
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.formContainer.addButton(cancelButton);
        this.formContainer.AddButtonPanelStyleName("cms_button_container");
    }

    private void updateWidgetsAccess() {
        boolean isCreating = this.record.getKey() == null;
        this.saveButton.setVisible(this.saveButtonIsVisible(isCreating));
    }

    private boolean saveButtonIsVisible(boolean isCreating) {
        boolean visible = isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) || this.parentPanel.isModifying() && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        return visible;
    }

    public void commit() {
        this.record.getCurrency().setName(this.nameTextBox.getText().trim());
        this.record.getCurrency().setSymbol(this.symbolTextBox.getText().trim());
    }

    public UiCurrencyRecord getRecord() {
        return this.record;
    }

    public void revert() {
        this.nameTextBox.setText(this.record.getCurrency().getName());
        this.symbolTextBox.setText(this.record.getCurrency().getSymbol());
        this.updateWidgetsAccess();
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        this.mainContainer.add((Widget)this.formContainer);
        return this.mainContainer;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            for (String message : ve.getValidationMessages()) {
                this.parentPanel.getErrorPanel().addMessage(message);
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage(throwable.getLocalizedMessage());
        }
    }

    protected void onUnload() {
        super.onUnload();
    }
}

