/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.MaxLenTextInputCell;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.table.AbstractEditableTable;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CurrencyListTable
extends AbstractEditableTable<UiCurrency> {
    public CurrencyListTable(String title, String recordDisplayName, boolean subField) {
        super(title, recordDisplayName, subField);
    }

    public CurrencyListTable(AbstractEditableTable.ClearMessagesCallback clearMessagesCallback, String recordDisplayName) {
        super(new ArrayList(), clearMessagesCallback, recordDisplayName);
    }

    @Override
    public List<UiCurrency> getCollapsedRecordList() {
        ArrayList<UiCurrency> collapsedList = new ArrayList<UiCurrency>();
        for (UiCurrency curCurrency : this.getRecords()) {
            if (curCurrency == null || curCurrency.getName() == null || curCurrency.getName().trim().isEmpty() || curCurrency.getSymbol() == null || curCurrency.getSymbol().trim().isEmpty()) continue;
            collapsedList.add(curCurrency);
        }
        return collapsedList;
    }

    @Override
    public void addNewRecord() {
        this.getRecords().add(new UiCurrency());
    }

    @Override
    protected void createTable(CellTable<UiCurrency> table) {
        Column<UiCurrency, String> nameColumn = this.createNameColumn();
        table.addColumn(nameColumn, this.constants.currency());
        Column<UiCurrency, String> symbolColumn = this.createSymbolColumn();
        table.addColumn(symbolColumn, this.constants.currencySymbolColumn());
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        Comparator<UiCurrency> nameCompare = new Comparator<UiCurrency>(){

            @Override
            public int compare(UiCurrency o1, UiCurrency o2) {
                if (o1 != null && o1.getName() != null) {
                    int i = o2 != null && o2.getName() != null ? o1.getName().compareTo(o2.getName()) : 1;
                    return i;
                }
                return -1;
            }
        };
        sortHandler.setComparator(nameColumn, (Comparator)nameCompare);
        sortHandler.setComparator(symbolColumn, (Comparator)new Comparator<UiCurrency>(){

            @Override
            public int compare(UiCurrency o1, UiCurrency o2) {
                if (o1 != null && o1.getSymbol() != null) {
                    int i = o2 != null && o2.getSymbol() != null ? o1.getSymbol().compareTo(o2.getSymbol()) : 1;
                    return i;
                }
                return -1;
            }
        });
        table.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        table.getColumnSortList().push(nameColumn);
        ColumnSortEvent.fire(table, (ColumnSortList)table.getColumnSortList());
    }

    private Column<UiCurrency, String> createNameColumn() {
        Column<UiCurrency, String> nameColumn = new Column<UiCurrency, String>((Cell)new MaxLenTextInputCell()){

            public String getValue(UiCurrency currencyRecord) {
                return currencyRecord.getName() == null ? "" : currencyRecord.getName();
            }
        };
        nameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiCurrency, String>(){

            public void update(int index, UiCurrency currencyRecord, String value) {
                CurrencyListTable.this.clearParentMessages();
                currencyRecord.setName(value);
                CurrencyListTable.this.setDirty();
            }
        });
        nameColumn.setSortable(true);
        nameColumn.setDefaultSortAscending(true);
        return nameColumn;
    }

    private Column<UiCurrency, String> createSymbolColumn() {
        Column<UiCurrency, String> symbolColumn = new Column<UiCurrency, String>((Cell)new MaxLenTextInputCell()){

            public String getValue(UiCurrency currencyRecord) {
                return currencyRecord.getSymbol() == null ? "" : currencyRecord.getSymbol();
            }
        };
        symbolColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiCurrency, String>(){

            public void update(int index, UiCurrency currencyRecord, String value) {
                CurrencyListTable.this.clearParentMessages();
                currencyRecord.setSymbol(value);
                CurrencyListTable.this.redrawRow(index);
                CurrencyListTable.this.setDirty();
            }
        });
        symbolColumn.setSortable(true);
        symbolColumn.setDefaultSortAscending(true);
        return symbolColumn;
    }

    @Override
    public String getRecordDisplayName() {
        return this.constants.currency();
    }
}

