/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyListTable;
import com.ericsson.cms.contractmgmt.client.table.AbstractEditableTable;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.List;

public class CurrencyMainDetailView
extends ConfigurableFieldDetailView {
    private ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final ConfigurableFieldListPanel parentPanel;

    public CurrencyMainDetailView(UiKeyNameRecord record, final DetailViewCallback<Long, UiKeyNameRecord> callback, final ConfigurableFieldListPanel parentPanel) {
        super(record, callback);
        this.parentPanel = parentPanel;
        AbstractEditableTable.ClearMessagesCallback cmcallback = new AbstractEditableTable.ClearMessagesCallback(){

            @Override
            public void clearMessages() {
                parentPanel.getSuccessPanel().reset();
                parentPanel.getErrorPanel().reset();
            }
        };
        final CurrencyListTable listTable = new CurrencyListTable(cmcallback, this.constants.currency());
        listTable.createTable();
        final BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.center();
        this.contractManagerDropDownService.getCurrencies((AsyncCallback<List<UiCurrency>>)new NeptuneAsyncCallback<List<UiCurrency>>(){

            public void onNeptuneSuccess(List<UiCurrency> result) {
                listTable.setRecordList(result);
                busyIndicator.hide();
            }

            public void onNeptuneFailure(Throwable t) {
            }
        });
        this.mainContainer.add((Widget)listTable);
        HorizontalContainer buttonRow = new HorizontalContainer();
        ButtonWidget saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                final BusyIndicator busyIndicator = new BusyIndicator();
                busyIndicator.center();
                CurrencyMainDetailView.this.contractManagerDropDownService.saveCurrencyList(listTable.getCollapsedRecordList(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneSuccess(Void v) {
                        parentPanel.getSuccessPanel().showMessage(CurrencyMainDetailView.this.messages.saveFieldSucceeded());
                        busyIndicator.hide();
                    }

                    public void onNeptuneFailure(Throwable t) {
                        busyIndicator.hide();
                        CurrencyMainDetailView.this.saveFailed(t);
                    }
                });
            }
        });
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        saveButton.addStyleName("ebBtn_color_green");
        saveButton.addStyleName("save_button_icon");
        buttonRow.add((Widget)saveButton);
        ButtonWidget backButton = new ButtonWidget(this.constants.backButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                parentPanel.getSuccessPanel().reset();
                callback.cancel((DetailView)CurrencyMainDetailView.this);
            }
        });
        backButton.removeStyleName("gwt-Button");
        backButton.addStyleName("ebBtn");
        buttonRow.add((Widget)backButton);
        buttonRow.addStyleName("cms_button_container");
        this.mainContainer.add((Widget)buttonRow);
    }

    @Override
    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            for (String message : ve.getValidationMessages()) {
                this.parentPanel.getErrorPanel().addMessage(message);
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage(throwable.getLocalizedMessage());
        }
    }
}

