/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom.CustomListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class CustomDataProvider
extends DropDownDataProvider<UiKeyNameRecord> {
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private Long userDefinedFieldId;
    private CustomListPanel parentPanel;

    public CustomDataProvider(Long userDefinedFieldId, CustomListPanel parentPanel) {
        this.userDefinedFieldId = userDefinedFieldId;
        this.parentPanel = parentPanel;
    }

    public void getRecords(final AsyncCallback<List<UiKeyNameRecord>> callback) {
        if (this.parentPanel.isEditing()) {
            this.notifyBusyStart();
            this.contractManagerDropDownService.getDropDownKeyNameList(this.userDefinedFieldId, (AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                    CustomDataProvider.this.notifyBusyFinish();
                }

                public void onNeptuneSuccess(List<UiKeyName> result) {
                    CustomDataProvider.this.records.clear();
                    for (UiKeyName uiKeyName : result) {
                        CustomDataProvider.this.records.add(new UiKeyNameRecord(uiKeyName));
                    }
                    callback.onSuccess((Object)CustomDataProvider.this.records);
                    CustomDataProvider.this.notifyBusyFinish();
                }
            });
        } else {
            this.records.clear();
            for (UiKeyName uiKeyName : this.parentPanel.getKeyNames()) {
                this.records.add(new UiKeyNameRecord(uiKeyName));
            }
            callback.onSuccess((Object)this.records);
        }
    }
}

