/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom.CustomListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import java.util.ArrayList;
import java.util.List;

public class CustomDetailFeature
extends DropDownDetailFeature<UiKeyNameRecord> {
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final CustomListPanel parentPanel;
    private final Long userDefinedFieldId;
    private boolean isCreating = false;
    private FieldTypeEnum type = FieldTypeEnum.Text;

    public CustomDetailFeature(Long userDefinedFieldId, CustomListPanel parentPanel, FieldTypeEnum type) {
        this.parentPanel = parentPanel;
        this.userDefinedFieldId = userDefinedFieldId;
        boolean bl = this.isCreating = userDefinedFieldId == null;
        if (type != null) {
            this.type = type;
        }
    }

    public void delete(List<UiKeyNameRecord> records, final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (this.parentPanel.isEditing()) {
                if (Window.confirm((String)this.messages.deleteDropDownConfirmation())) {
                    ArrayList<UiKeyName> keyNames = new ArrayList<UiKeyName>();
                    for (UiKeyNameRecord record : records) {
                        keyNames.add(record.getKeyName());
                    }
                    this.parentPanel.clearMessages();
                    this.contractManagerDropDownService.deleteCustomDropDownKeyNames(keyNames, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                        public void onNeptuneFailure(Throwable caught) {
                            CustomDetailFeature.this.parentPanel.getErrorPanel().showMessage(CustomDetailFeature.this.messages.deleteDropDownError());
                            if (caught instanceof ValidationException) {
                                ValidationException ve = (ValidationException)caught;
                                for (String message : ve.getValidationMessages()) {
                                    CustomDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                                }
                            } else {
                                callback.onFailure(caught);
                            }
                        }

                        public void onNeptuneSuccess(Void result) {
                            CustomDetailFeature.this.parentPanel.getSuccessPanel().showMessage(CustomDetailFeature.this.messages.deleteDropDownSucceeded());
                            callback.onSuccess(null);
                        }
                    });
                }
            } else {
                for (UiKeyNameRecord record : records) {
                    this.parentPanel.getKeyNames().remove(record.getKeyName());
                }
                callback.onSuccess(null);
            }
        } else {
            Window.alert((String)this.messages.noDropDownSelected());
        }
    }

    public void getNew(AsyncCallback<UiKeyNameRecord> callback) {
        this.parentPanel.clearMessages();
        callback.onSuccess((Object)new UiKeyNameRecord(new UiKeyName()));
    }

    public DetailView<Long, UiKeyNameRecord> getView(UiKeyNameRecord record, DetailViewCallback<Long, UiKeyNameRecord> callback) {
        this.parentPanel.clearMessages();
        DropDownDetailView view = new DropDownDetailView(record, callback, !this.isCreating, this.type);
        return view;
    }

    public void save(UiKeyNameRecord record, final AsyncCallback<Void> callback) {
        if (this.parentPanel.isEditing()) {
            this.parentPanel.clearMessages();
            this.contractManagerDropDownService.saveCustomDropDownKeyName(record.getKeyName(), this.userDefinedFieldId, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneFailure(Throwable caught) {
                    CustomDetailFeature.this.parentPanel.getTable().refresh();
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(Void result) {
                    CustomDetailFeature.this.parentPanel.getSuccessPanel().showMessage(CustomDetailFeature.this.messages.saveDropDownSucceeded());
                    callback.onSuccess(null);
                }
            });
        } else {
            boolean exists = false;
            for (UiKeyName keyName : this.parentPanel.getKeyNames()) {
                if (!record.getKeyName().getName().equals(keyName.getName())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.parentPanel.getKeyNames().add(record.getKeyName());
            }
            callback.onSuccess(null);
        }
    }

    @Override
    public boolean showCreateButton() {
        return this.isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !this.isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
    }

    @Override
    public boolean showDeleteButton() {
        return this.isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !this.isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
    }
}

