/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDevices;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.UiDeviceRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.List;

public class DeviceDataProvider
extends DropDownDataProvider<UiDeviceRecord> {
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final ColumnBase<String, UiDeviceRecord> platformColumn = new ColumnBase<String, UiDeviceRecord>(PLATFORM_COLUMN, this.constants.configurationPlatformColumn()){

        public View<String> getView(UiDeviceRecord record) {
            return new LabelStringView(record.getDevice().getPlatform().getName());
        }
    };
    private static String PLATFORM_COLUMN = "platform";

    public DeviceDataProvider() {
        this.platformColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add(this.platformColumn);
    }

    public void getRecords(final AsyncCallback<List<UiDeviceRecord>> callback) {
        this.notifyBusyStart();
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.contractManagerDropDownService.getDevices(start, length, this.getParentSortFeature().getSortColumnName(), this.getParentSortFeature().isAscending(), (AsyncCallback<UiDevices>)new NeptuneAsyncCallback<UiDevices>(){

            public void onNeptuneFailure(Throwable caught) {
                DeviceDataProvider.this.getParentPageFeature().setRecordCount(-1);
                DeviceDataProvider.this.notifyBusyFinish();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiDevices result) {
                DeviceDataProvider.this.getParentPageFeature().setRecordCount(result.getTotalCount());
                DeviceDataProvider.this.records.clear();
                for (UiDevice device : result.getDevices()) {
                    DeviceDataProvider.this.records.add(new UiDeviceRecord(device));
                }
                DeviceDataProvider.this.notifyBusyFinish();
                callback.onSuccess((Object)DeviceDataProvider.this.records);
            }
        });
    }
}

