/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.DeviceDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.DeviceListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.UiDeviceRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import java.util.ArrayList;
import java.util.List;

public class DeviceDetailFeature
extends DropDownDetailFeature<UiDeviceRecord> {
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private DeviceListPanel parentPanel;

    public DeviceDetailFeature(DeviceListPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiDeviceRecord> records, final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (Window.confirm((String)this.messages.deleteGenericConfirmation(ConfigurableFieldTypeEnum.Device.getDisplayName()))) {
                ArrayList<UiDevice> devices = new ArrayList<UiDevice>();
                for (UiDeviceRecord record : records) {
                    devices.add(record.getDevice());
                }
                this.contractManagerDropDownService.deleteDevices(devices, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        DeviceDetailFeature.this.parentPanel.getTable().refresh();
                        DeviceDetailFeature.this.parentPanel.getErrorPanel().showMessage(String.valueOf(DeviceDetailFeature.this.messages.deleteGenericError()) + " " + ConfigurableFieldTypeEnum.Device.getDisplayName());
                        if (caught instanceof ValidationException) {
                            ValidationException ve = (ValidationException)caught;
                            for (String message : ve.getValidationMessages()) {
                                DeviceDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                            }
                        } else {
                            callback.onFailure(caught);
                        }
                    }

                    public void onNeptuneSuccess(Void result) {
                        DeviceDetailFeature.this.parentPanel.getSuccessPanel().showMessage(String.valueOf(ConfigurableFieldTypeEnum.Device.getDisplayName()) + " " + DeviceDetailFeature.this.messages.deleteGenericSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)(String.valueOf(this.messages.noGenericSelected()) + " " + ConfigurableFieldTypeEnum.Device.getDisplayName()));
        }
    }

    public void getNew(AsyncCallback<UiDeviceRecord> callback) {
        this.parentPanel.clearMessages();
        callback.onSuccess((Object)new UiDeviceRecord(new UiDevice()));
    }

    public DetailView<Long, UiDeviceRecord> getView(UiDeviceRecord record, DetailViewCallback<Long, UiDeviceRecord> callback) {
        this.parentPanel.clearMessages();
        DeviceDetailView view = new DeviceDetailView(this.parentPanel, record, callback);
        return view;
    }

    public void save(UiDeviceRecord record, final AsyncCallback<Void> callback) {
        this.contractManagerDropDownService.saveDevice(record.getDevice(), (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                DeviceDetailFeature.this.parentPanel.getErrorPanel().showMessage(String.valueOf(DeviceDetailFeature.this.messages.saveGenericError()) + " " + ConfigurableFieldTypeEnum.Device.getDisplayName());
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Void result) {
                DeviceDetailFeature.this.parentPanel.getSuccessPanel().showMessage(String.valueOf(ConfigurableFieldTypeEnum.Device.getDisplayName()) + " " + DeviceDetailFeature.this.messages.saveGenericSucceeded());
                callback.onSuccess(null);
            }
        });
    }
}

