/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.DeviceListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.UiDeviceRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import java.util.List;

public class DeviceDetailView
extends Composite
implements DetailView<Long, UiDeviceRecord> {
    private UiDeviceRecord record;
    private DetailViewCallback<Long, UiDeviceRecord> callback;
    private VerticalContainer mainContainer;
    private static final int MAX_LENGTH = 50;
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private TextBoxWidget nameTextBox = new TextBoxWidget();
    private TypedListBoxWidget<Long> platformListBox;
    private ButtonWidget saveButton;
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private DeviceListPanel parentPanel;

    public DeviceDetailView(DeviceListPanel parentPanel, UiDeviceRecord record, DetailViewCallback<Long, UiDeviceRecord> callback) {
        this.record = record;
        this.callback = callback;
        this.parentPanel = parentPanel;
        this.mainContainer = new VerticalContainer();
        this.initForm();
        this.updateWidgetsAccess();
    }

    private void initForm() {
        this.nameTextBox.setMaxLength(50);
        this.nameTextBox.setText(this.record.getKeyName().getName());
        this.formContainer.addRow(this.constants.configurationNameColumn(), (Widget)this.nameTextBox, true);
        this.platformListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.loadPlatformListBox(this.platformListBox, this.record.getDevice().getPlatform().getKey());
        this.formContainer.addRow(this.constants.configurationPlatformColumn(), (Widget)this.platformListBox, true);
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DeviceDetailView.this.parentPanel.clearMessages();
                if (DeviceDetailView.this.formContainer.validate()) {
                    DeviceDetailView.this.callback.save((DetailView)DeviceDetailView.this);
                }
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.formContainer.addButton(this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DeviceDetailView.this.parentPanel.clearMessages();
                DeviceDetailView.this.callback.cancel((DetailView)DeviceDetailView.this);
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.formContainer.addButton(cancelButton);
    }

    private void loadPlatformListBox(final TypedListBoxWidget<Long> lbPlatform, final Long selected) {
        lbPlatform.clear();
        this.contractManagerDropDownService.getPlatformList((AsyncCallback<List<UiPlatform>>)new NeptuneAsyncCallback<List<UiPlatform>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)DeviceDetailView.this.constants.failureGettingContentProviders());
            }

            public void onNeptuneSuccess(List<UiPlatform> result) {
                lbPlatform.addItem("", null);
                for (UiPlatform platform : result) {
                    lbPlatform.addItem(platform.getName(), (Object)platform.getKey());
                }
                lbPlatform.setSelectedItem((Object)selected);
            }
        });
    }

    private void updateWidgetsAccess() {
        boolean isCreating = this.record.getKey() == null;
        this.saveButton.setVisible(this.saveButtonIsVisible(isCreating));
    }

    private boolean saveButtonIsVisible(boolean isCreating) {
        boolean visible = isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        return visible;
    }

    public void commit() {
        this.record.getDevice().setName(this.nameTextBox.getText().trim());
        this.record.getDevice().getPlatform().setKey((Long)this.platformListBox.getSelectedItem());
    }

    public UiDeviceRecord getRecord() {
        return this.record;
    }

    public void revert() {
        this.nameTextBox.setText(this.record.getDevice().getName());
        this.platformListBox.setSelectedItem((Object)this.record.getDevice().getPlatform().getKey());
        this.updateWidgetsAccess();
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        this.mainContainer.add((Widget)this.formContainer);
        return this.mainContainer;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            for (String message : ve.getValidationMessages()) {
                this.parentPanel.getErrorPanel().addMessage(message);
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage(throwable.getLocalizedMessage());
        }
    }

    protected void onUnload() {
        super.onUnload();
    }
}

