/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import com.ericsson.cms.contractmgmt.client.MaxLenTextInputCell;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.table.AbstractEditableTable;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.SelectionCell;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DeviceListTable
extends AbstractEditableTable<UiDevice> {
    private List<UiPlatform> platformList = new ArrayList<UiPlatform>();

    public DeviceListTable(AbstractEditableTable.ClearMessagesCallback cmCallback, String recordDisplayName) {
        super(new ArrayList(), cmCallback, recordDisplayName);
    }

    public DeviceListTable(String title, String displayRecordName) {
        super(title, displayRecordName);
    }

    public DeviceListTable(List<UiDevice> recordList, List<UiPlatform> platformList, String title, String displayName) {
        super(recordList, title, displayName, true);
        this.platformList = platformList;
        this.initWidgets();
    }

    @Override
    public List<UiDevice> getCollapsedRecordList() {
        ArrayList<UiDevice> collapsedList = new ArrayList<UiDevice>();
        for (UiDevice curRecord : this.recordList) {
            if (curRecord == null || curRecord.getName() == null || curRecord.getName().trim().isEmpty() || curRecord.getPlatform() == null) continue;
            collapsedList.add(curRecord);
        }
        return collapsedList;
    }

    @Override
    public void addNewRecord() {
        UiDevice newDevice = new UiDevice();
        if (this.platformList != null && !this.platformList.isEmpty()) {
            newDevice.setPlatform(this.platformList.get(0));
        }
        this.getRecords().add(newDevice);
    }

    public void setPlatformList(List<UiPlatform> platformList) {
        Collections.sort(platformList);
        this.platformList = platformList;
    }

    public List<UiPlatform> getPlatformList() {
        return this.platformList;
    }

    public List<String> getPlatformStrings() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (UiPlatform curPlatform : this.getPlatformList()) {
            stringList.add(curPlatform.getName());
        }
        return stringList;
    }

    @Override
    protected void createTable(CellTable<UiDevice> table) {
        Column<UiDevice, String> nameColumn = this.createNameColumn();
        table.addColumn(nameColumn, this.constants.deviceListHeading());
        Column<UiDevice, String> platformColumn = this.createPlatformColumn();
        table.addColumn(platformColumn, this.constants.platformListHeading());
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        Comparator<UiDevice> nameCompare = new Comparator<UiDevice>(){

            @Override
            public int compare(UiDevice o1, UiDevice o2) {
                if (o1 != null && o1.getName() != null) {
                    int i = o2 != null && o2.getName() != null ? o1.getName().compareTo(o2.getName()) : 1;
                    return i;
                }
                return -1;
            }
        };
        sortHandler.setComparator(nameColumn, (Comparator)nameCompare);
        sortHandler.setComparator(platformColumn, (Comparator)new Comparator<UiDevice>(){

            @Override
            public int compare(UiDevice o1, UiDevice o2) {
                if (o1 != null && o1.getPlatform() != null) {
                    int i = o2 != null && o2.getPlatform() != null ? o1.getPlatform().compareTo(o2.getPlatform()) : 1;
                    return i;
                }
                return -1;
            }
        });
        table.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        table.getColumnSortList().push(nameColumn);
        ColumnSortEvent.fire(table, (ColumnSortList)table.getColumnSortList());
    }

    private Column<UiDevice, String> createNameColumn() {
        Column<UiDevice, String> nameColumn = new Column<UiDevice, String>((Cell)new MaxLenTextInputCell()){

            public String getValue(UiDevice record) {
                return record.getName() == null ? "" : record.getName();
            }
        };
        nameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiDevice, String>(){

            public void update(int index, UiDevice record, String value) {
                DeviceListTable.this.clearParentMessages();
                record.setName(value);
                DeviceListTable.this.setDirty();
            }
        });
        nameColumn.setSortable(true);
        nameColumn.setDefaultSortAscending(true);
        return nameColumn;
    }

    private Column<UiDevice, String> createPlatformColumn() {
        Column<UiDevice, String> platformColumn = new Column<UiDevice, String>((Cell)new SelectionCell(this.getPlatformStrings())){

            public String getValue(UiDevice record) {
                String value = "";
                if (record != null && record.getPlatform() != null) {
                    value = record.getPlatform().getName();
                }
                return value;
            }
        };
        platformColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiDevice, String>(){

            public void update(int index, UiDevice record, String value) {
                DeviceListTable.this.clearParentMessages();
                UiPlatform selected = DeviceListTable.findPlatform(value, DeviceListTable.this.getPlatformList());
                record.setPlatform(selected);
                DeviceListTable.this.redrawRow(index);
                DeviceListTable.this.setDirty();
            }
        });
        platformColumn.setSortable(true);
        platformColumn.setDefaultSortAscending(true);
        return platformColumn;
    }

    private static UiPlatform findPlatform(String name, List<UiPlatform> platformList) {
        if (platformList != null && name != null) {
            for (UiPlatform curPlatform : platformList) {
                if (!name.equals(curPlatform.getName())) continue;
                return curPlatform;
            }
        }
        return null;
    }
}

