/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class GenericDataProvider
implements DataProvider<Long, UiKeyNameRecord> {
    private ConfigurableFieldTypeEnum fieldType;
    protected final List<Column<?, UiKeyNameRecord>> columns;
    private final ColumnBase<String, UiKeyNameRecord> nameColumn;
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiKeyNameRecord> parentSortFeature;
    protected ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    protected List<UiKeyNameRecord> records;
    private static String NAME_COLUMN = "name";
    private IBusyNotifier busyNotifier;
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);

    public GenericDataProvider(ConfigurableFieldTypeEnum fieldType) {
        this.fieldType = fieldType;
        this.records = new ArrayList<UiKeyNameRecord>();
        this.columns = new ArrayList();
        this.nameColumn = new ColumnBase<String, UiKeyNameRecord>(NAME_COLUMN, this.constants.configurationDropDownNameColumn()){

            public View<String> getView(UiKeyNameRecord record) {
                return new LabelStringView(record.getKeyName().getName());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiKeyNameRecord>)this.nameColumn);
    }

    public void getRecords(final AsyncCallback<List<UiKeyNameRecord>> callback) {
        this.notifyBusyStart();
        int length = 0;
        int start = 0;
        if (this.parentPageFeature != null) {
            length = this.parentPageFeature.getPageSize();
            start = (this.parentPageFeature.getPageNumber() - 1) * length;
        }
        String sortColumn = "";
        boolean isAcending = true;
        if (this.parentSortFeature != null) {
            sortColumn = this.getParentSortFeature().getSortColumnName();
            isAcending = this.getParentSortFeature().isAscending();
        }
        this.contractManagerDropDownService.getGenericDropDownKeyNameList(start, length, sortColumn, isAcending, this.fieldType, (AsyncCallback<UiKeyNames>)new NeptuneAsyncCallback<UiKeyNames>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiKeyNames result) {
                GenericDataProvider.this.records.clear();
                for (UiKeyName uiKeyName : result.getRecords()) {
                    GenericDataProvider.this.records.add(new UiKeyNameRecord(uiKeyName));
                }
                if (GenericDataProvider.this.parentPageFeature != null) {
                    GenericDataProvider.this.parentPageFeature.setRecordCount(result.getTotalCount());
                }
                callback.onSuccess(GenericDataProvider.this.records);
                GenericDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public ColumnBase<String, UiKeyNameRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiKeyNameRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiKeyNameRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<UiKeyNameRecord> callback) {
        for (UiKeyNameRecord record : this.records) {
            if (!record.getKey().equals(key)) continue;
            callback.onSuccess((Object)record);
            break;
        }
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return this.fieldType != ConfigurableFieldTypeEnum.MetaFormat;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    protected void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    protected void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UiKeyNameRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiKeyNameRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

