/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.ArrayList;
import java.util.List;

public class GenericDetailFeature
extends AbstractDetailFeature<Long, UiKeyNameRecord> {
    private final ConfigurableFieldTypeEnum fieldType;
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final GenericListPanel parentPanel;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);

    public GenericDetailFeature(GenericListPanel parentPanel, ConfigurableFieldTypeEnum fieldType) {
        super((KeySerializer)new UiLongKeySerializer());
        this.parentPanel = parentPanel;
        this.fieldType = fieldType;
    }

    public boolean hasDetailLink(Column<?, UiKeyNameRecord> column) {
        if (this.fieldType.equals((Object)ConfigurableFieldTypeEnum.MetaFormat)) {
            return false;
        }
        return column.getDisplayName().equals(this.constants.contractNameColumn()) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
    }

    public boolean showCreateButton() {
        if (this.fieldType.equals((Object)ConfigurableFieldTypeEnum.MetaFormat)) {
            return false;
        }
        if (this.fieldType.equals((Object)ConfigurableFieldTypeEnum.Frequency)) {
            if (this.parentPanel.isModifying()) {
                return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
            }
            return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
        }
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
    }

    public boolean showDeleteButton() {
        if (this.fieldType.equals((Object)ConfigurableFieldTypeEnum.MetaFormat)) {
            return false;
        }
        if (this.fieldType.equals((Object)ConfigurableFieldTypeEnum.Frequency)) {
            if (this.parentPanel.isModifying()) {
                return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
            }
            return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
        }
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
    }

    public void delete(List<UiKeyNameRecord> records, final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (Window.confirm((String)this.messages.deleteGenericConfirmation(this.fieldType.getDisplayName()))) {
                ArrayList<UiKeyName> keyNames = new ArrayList<UiKeyName>();
                for (UiKeyNameRecord record : records) {
                    keyNames.add(record.getKeyName());
                }
                this.parentPanel.clearMessages();
                this.contractManagerDropDownService.deleteGenericDropDownKeyNames(keyNames, this.fieldType, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        GenericDetailFeature.this.parentPanel.getTable().refresh();
                        GenericDetailFeature.this.parentPanel.getErrorPanel().showMessage(String.valueOf(GenericDetailFeature.this.messages.deleteGenericError()) + " " + GenericDetailFeature.this.fieldType.getDisplayName());
                        if (caught instanceof ValidationException) {
                            ValidationException ve = (ValidationException)caught;
                            for (String message : ve.getValidationMessages()) {
                                GenericDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                            }
                        } else {
                            callback.onFailure(caught);
                        }
                    }

                    public void onNeptuneSuccess(Void result) {
                        GenericDetailFeature.this.parentPanel.getSuccessPanel().showMessage(String.valueOf(GenericDetailFeature.this.fieldType.getDisplayName()) + " " + GenericDetailFeature.this.messages.deleteGenericSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)(String.valueOf(this.messages.noGenericSelected()) + " " + this.fieldType.getDisplayName()));
        }
    }

    public void getNew(AsyncCallback<UiKeyNameRecord> callback) {
        this.parentPanel.clearMessages();
        callback.onSuccess((Object)new UiKeyNameRecord(new UiKeyName()));
    }

    public DetailView<Long, UiKeyNameRecord> getView(UiKeyNameRecord record, DetailViewCallback<Long, UiKeyNameRecord> callback) {
        this.parentPanel.clearMessages();
        boolean parentModifying = this.fieldType.equals((Object)ConfigurableFieldTypeEnum.Frequency) ? this.parentPanel.isModifying() : false;
        DropDownDetailView view = new DropDownDetailView(record, callback, parentModifying, null);
        return view;
    }

    public void save(UiKeyNameRecord record, final AsyncCallback<Void> callback) {
        this.parentPanel.clearMessages();
        this.contractManagerDropDownService.saveGenericDropDownKeyName(record.getKeyName(), this.fieldType, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Void result) {
                GenericDetailFeature.this.parentPanel.getSuccessPanel().showMessage(String.valueOf(GenericDetailFeature.this.fieldType.getDisplayName()) + " " + GenericDetailFeature.this.messages.saveGenericSucceeded());
                callback.onSuccess(null);
            }
        });
    }
}

