/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericDetailFeature;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class GenericListPanel
extends Composite {
    private ConfigurableFieldTypeEnum fieldType;
    private GenericDataProvider dataProvider;
    private GenericDetailFeature detailFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<Long, UiKeyNameRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    protected ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private boolean isModifying;
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";

    public GenericListPanel(ConfigurableFieldTypeEnum fieldType, boolean isModifying) {
        this.fieldType = fieldType;
        this.isModifying = isModifying;
        this.dataProvider = new GenericDataProvider(fieldType);
        this.dataProvider.setBusyNotifier(new GenericDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                GenericListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                GenericListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<Long, UiKeyNameRecord>(){

            public void onShowDetailView(TableDetailViewEvent<Long, UiKeyNameRecord> event) {
                if (event.isCreateView()) {
                    GenericListPanel.this.header.setLabel(GenericListPanel.this.getDetailsHeading());
                } else {
                    GenericListPanel.this.header.setLabel(String.valueOf(GenericListPanel.this.getDetailsHeading()) + " " + ((UiKeyNameRecord)event.getRecord()).getKeyName().getName());
                }
            }

            public void onShowListView(TableViewEvent event) {
                GenericListPanel.this.header.setLabel(GenericListPanel.this.getListHeading());
            }
        });
        this.detailFeature = new GenericDetailFeature(this, this.fieldType);
        if (this.fieldType.hasPageFeature()) {
            PageFeatureImpl pageFeature = new PageFeatureImpl();
            this.dataProvider.setParentPageFeature((PageFeature)pageFeature);
            this.table.addPageFeature((PageFeature)pageFeature);
        }
        if (this.fieldType.hasSortFeature()) {
            SortFeatureImpl sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
            this.dataProvider.setParentSortFeature((SortFeatureImpl<Long, UiKeyNameRecord>)sortFeature);
            for (Column<?, UiKeyNameRecord> col : this.dataProvider.getSortColumns()) {
                sortFeature.addSortableColumn(col);
            }
            this.dataProvider.setParentSortFeature((SortFeatureImpl<Long, UiKeyNameRecord>)sortFeature);
        }
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
                GenericListPanel.this.table.refresh();
            }
        });
        this.anchorChangeListener = new GenericAnchorChangeListener(this);
    }

    public String getDetailsHeading() {
        return String.valueOf(this.fieldType.getDisplayName()) + " " + this.constants.genericDetailsHeading();
    }

    public String getListHeading() {
        return String.valueOf(this.fieldType.getDisplayName()) + " " + this.constants.genericListHeading();
    }

    public Table<Long, UiKeyNameRecord> getTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }

    public boolean isModifying() {
        return this.isModifying;
    }
}

