/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import com.ericsson.cms.contractmgmt.client.MaxLenTextInputCell;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.table.AbstractEditableTable;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class GenericListTable
extends AbstractEditableTable<UiKeyName> {
    boolean editable = true;

    public GenericListTable(String title, String recordDisplayName, boolean subField) {
        super(title, recordDisplayName, subField);
    }

    public GenericListTable(String title, AbstractEditableTable.ClearMessagesCallback clearMessagesCallback) {
        super(new ArrayList(), clearMessagesCallback, title);
    }

    @Override
    public List<UiKeyName> getCollapsedRecordList() {
        ArrayList<UiKeyName> collapsedList = new ArrayList<UiKeyName>();
        for (UiKeyName curKeyName : this.getRecords()) {
            if (curKeyName == null || curKeyName.getName() == null || curKeyName.getName().trim().isEmpty()) continue;
            collapsedList.add(curKeyName);
        }
        return collapsedList;
    }

    @Override
    public void addNewRecord() {
        this.getRecords().add(new UiKeyName());
    }

    @Override
    protected void createTable(CellTable<UiKeyName> table) {
        Column<UiKeyName, String> nameColumn = this.createNameColumn();
        table.addColumn(nameColumn, this.constants.contractNameColumn());
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        Comparator<UiKeyName> nameCompare = new Comparator<UiKeyName>(){

            @Override
            public int compare(UiKeyName o1, UiKeyName o2) {
                if (o1 != null) {
                    int i = o2 != null ? o1.getName().compareTo(o2.getName()) : 1;
                    return i;
                }
                return -1;
            }
        };
        sortHandler.setComparator(nameColumn, (Comparator)nameCompare);
        table.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        table.getColumnSortList().push(nameColumn);
        ColumnSortEvent.fire(table, (ColumnSortList)table.getColumnSortList());
    }

    private Column<UiKeyName, String> createNameColumn() {
        MaxLenTextInputCell valueCell = this.editable ? new MaxLenTextInputCell() : new TextCell();
        Column<UiKeyName, String> nameColumn = new Column<UiKeyName, String>((Cell)valueCell){

            public String getValue(UiKeyName key) {
                return key.getName() == null ? "" : key.getName();
            }
        };
        nameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiKeyName, String>(){

            public void update(int index, UiKeyName key, String value) {
                GenericListTable.this.clearParentMessages();
                key.setName(value);
                GenericListTable.this.setDirty();
            }
        });
        nameColumn.setSortable(true);
        nameColumn.setDefaultSortAscending(true);
        return nameColumn;
    }

    @Override
    protected ButtonWidget createAddButton() {
        ButtonWidget addBtn = null;
        if (this.editable) {
            addBtn = new ButtonWidget(String.valueOf(this.constants.addRecordButtonName()) + this.getRecordDisplayName());
            addBtn.removeStyleName("gwt-Button");
            addBtn.addStyleName("ebBtn");
            addBtn.addStyleName("addgreen_button_icon");
            addBtn.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GenericListTable.this.addNewRecord();
                    GenericListTable.this.dataProvider.refresh();
                    GenericListTable.this.pager.lastPage();
                }
            });
        }
        return addBtn;
    }

    @Override
    protected Column<UiKeyName, String> createDeleteColumn() {
        if (!this.editable) {
            return null;
        }
        return super.createDeleteColumn();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

