/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericListTable;
import com.ericsson.cms.contractmgmt.client.table.AbstractEditableTable;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class GenericMainDetailView
extends ConfigurableFieldDetailView {
    private ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private GenericListTable listPanel;
    private ErrorPanel errorPanel;
    private SuccessPanel successPanel;
    private ConfigurableFieldTypeEnum fieldType;

    public GenericMainDetailView(ConfigurableFieldTypeEnum fieldType, UiKeyNameRecord record, final DetailViewCallback<Long, UiKeyNameRecord> callback) {
        super(record, callback);
        this.fieldType = fieldType;
        this.errorPanel = new ErrorPanel();
        this.mainContainer.add((Widget)this.errorPanel);
        this.successPanel = new SuccessPanel();
        this.mainContainer.add((Widget)this.successPanel);
        this.listPanel = new GenericListTable(fieldType.getDisplayName(), new AbstractEditableTable.ClearMessagesCallback(){

            @Override
            public void clearMessages() {
                GenericMainDetailView.this.clearStatusMessages();
            }
        });
        if (ConfigurableFieldTypeEnum.MetaFormat == fieldType) {
            this.listPanel.setEditable(false);
        }
        this.listPanel.createTable();
        this.mainContainer.add((Widget)this.listPanel);
        this.contractManagerDropDownService.getGenericDropDownKeyNameList(0, 0, null, true, fieldType, (AsyncCallback<UiKeyNames>)new NeptuneAsyncCallback<UiKeyNames>(){

            public void onNeptuneSuccess(UiKeyNames result) {
                GenericMainDetailView.this.listPanel.setRecordList(result.getRecords());
            }

            public void onNeptuneFailure(Throwable t) {
            }
        });
        HorizontalContainer buttonRow = new HorizontalContainer();
        ButtonWidget saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                callback.save((DetailView)GenericMainDetailView.this);
            }
        });
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        saveButton.addStyleName("ebBtn_color_green");
        saveButton.addStyleName("save_button_icon");
        buttonRow.add((Widget)saveButton);
        ButtonWidget backButton = new ButtonWidget(this.constants.backButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                callback.cancel((DetailView)GenericMainDetailView.this);
            }
        });
        backButton.removeStyleName("gwt-Button");
        backButton.addStyleName("ebBtn");
        buttonRow.add((Widget)backButton);
        buttonRow.addStyleName("cms_button_container");
        this.mainContainer.add((Widget)buttonRow);
    }

    @Override
    public void commit() {
        this.clearStatusMessages();
        if (this.listPanel != null) {
            final BusyIndicator busyIndicator = new BusyIndicator();
            busyIndicator.center();
            this.contractManagerDropDownService.saveGenericDropDownKeyList(this.listPanel.getCollapsedRecordList(), this.fieldType, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                public void onNeptuneSuccess(Void result) {
                    busyIndicator.hide();
                    GenericMainDetailView.this.successPanel.showMessage(GenericMainDetailView.this.messages.saveFieldSucceeded());
                }

                public void onNeptuneFailure(Throwable t) {
                    busyIndicator.hide();
                    GenericMainDetailView.this.saveFailed(t);
                }
            });
        }
    }

    @Override
    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            for (String message : ve.getValidationMessages()) {
                this.errorPanel.addMessage(message);
            }
        } else {
            this.errorPanel.showMessage(throwable.getLocalizedMessage());
        }
    }

    public void clearStatusMessages() {
        if (this.errorPanel != null) {
            this.errorPanel.reset();
        }
        if (this.successPanel != null) {
            this.successPanel.reset();
        }
    }
}

