/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contacts;

import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;
import com.google.gwt.view.client.SelectionModel;

public class ContactEditTextCell
extends AbstractEditableCell<String, ViewData> {
    private static Template template;
    private final SafeHtmlRenderer<String> renderer;
    private SelectionModel<UiContact> selectionModel;

    public ContactEditTextCell() {
        this((SafeHtmlRenderer<String>)SimpleSafeHtmlRenderer.getInstance());
    }

    public ContactEditTextCell(SelectionModel<UiContact> selectionModel) {
        this((SafeHtmlRenderer<String>)SimpleSafeHtmlRenderer.getInstance());
        this.selectionModel = selectionModel;
    }

    public ContactEditTextCell(SafeHtmlRenderer<String> renderer) {
        super(new String[]{"click", "keyup", "keydown", "blur"});
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        this.renderer = renderer;
    }

    public boolean isEditing(Cell.Context context, Element parent, String value) {
        ViewData viewData = (ViewData)this.getViewData(context.getKey());
        return viewData == null ? false : viewData.isEditing();
    }

    public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        Object key = context.getKey();
        ViewData viewData = (ViewData)this.getViewData(key);
        if (viewData != null && viewData.isEditing()) {
            this.editEvent(context, parent, value, viewData, event, valueUpdater);
        } else {
            boolean enterPressed;
            String type = event.getType();
            int keyCode = event.getKeyCode();
            boolean bl = enterPressed = "keyup".equals(type) && keyCode == 13;
            if ("click".equals(type) || enterPressed) {
                if (viewData == null) {
                    viewData = new ViewData(value);
                    this.setViewData(key, viewData);
                } else {
                    viewData.setEditing(true);
                }
                this.edit(context, parent, value);
            }
        }
    }

    public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
        Object key = context.getKey();
        UiContact contact = (UiContact)key;
        String toRender = value;
        if (this.selectionModel.isSelected((Object)contact)) {
            sb.append(template.input(value));
            return;
        }
        if (toRender != null && toRender.trim().length() > 0) {
            sb.append(this.renderer.render((Object)toRender));
        } else {
            sb.appendHtmlConstant("\u00a0");
        }
    }

    public boolean resetFocus(Cell.Context context, Element parent, String value) {
        if (this.isEditing(context, parent, value)) {
            this.getInputElement(parent).focus();
            return true;
        }
        return false;
    }

    protected void edit(Cell.Context context, Element parent, String value) {
        this.setValue(context, parent, value);
        InputElement input = this.getInputElement(parent);
        input.focus();
        input.select();
    }

    private void cancel(Cell.Context context, Element parent, String value) {
        this.clearInput((Element)this.getInputElement(parent));
        this.setValue(context, parent, value);
    }

    private native void clearInput(Element var1);

    private void commit(Cell.Context context, Element parent, ViewData viewData, ValueUpdater<String> valueUpdater) {
        String value = this.updateViewData(parent, viewData, false);
        this.clearInput((Element)this.getInputElement(parent));
        this.setValue(context, parent, viewData.getOriginal());
        if (valueUpdater != null) {
            valueUpdater.update((Object)value);
        }
    }

    private void editEvent(Cell.Context context, Element parent, String value, ViewData viewData, NativeEvent event, ValueUpdater<String> valueUpdater) {
        Element target;
        EventTarget eventTarget;
        String type = event.getType();
        boolean keyUp = "keyup".equals(type);
        boolean keyDown = "keydown".equals(type);
        if (keyUp || keyDown) {
            int keyCode = event.getKeyCode();
            if (keyUp && keyCode == 13) {
                this.commit(context, parent, viewData, valueUpdater);
            } else if (keyUp && keyCode == 27) {
                String originalText = viewData.getOriginal();
                if (viewData.isEditingAgain()) {
                    viewData.setText(originalText);
                    viewData.setEditing(false);
                } else {
                    this.setViewData(context.getKey(), null);
                }
                this.cancel(context, parent, value);
            } else {
                this.updateViewData(parent, viewData, true);
            }
        } else if ("blur".equals(type) && Element.is((JavaScriptObject)(eventTarget = event.getEventTarget())) && "input".equals((target = Element.as((JavaScriptObject)eventTarget)).getTagName().toLowerCase())) {
            this.commit(context, parent, viewData, valueUpdater);
        }
    }

    private InputElement getInputElement(Element parent) {
        return (InputElement)parent.getFirstChild().cast();
    }

    private String updateViewData(Element parent, ViewData viewData, boolean isEditing) {
        InputElement input = (InputElement)parent.getFirstChild();
        String value = input.getValue();
        viewData.setText(value);
        viewData.setEditing(isEditing);
        return value;
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<input type=\"text\" value=\"{0}\" tabindex=\"-1\"></input>")
        public SafeHtml input(String var1);
    }

    static class ViewData {
        private boolean isEditing;
        private boolean isEditingAgain;
        private String original;
        private String text;

        public ViewData(String text) {
            this.original = text;
            this.text = text;
            this.isEditing = true;
            this.isEditingAgain = false;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            ViewData vd = (ViewData)o;
            return this.equalsOrBothNull(this.original, vd.original) && this.equalsOrBothNull(this.text, vd.text) && this.isEditing == vd.isEditing && this.isEditingAgain == vd.isEditingAgain;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getText() {
            return this.text;
        }

        public int hashCode() {
            return this.original.hashCode() + this.text.hashCode() + Boolean.valueOf(this.isEditing).hashCode() * 29 + Boolean.valueOf(this.isEditingAgain).hashCode();
        }

        public boolean isEditing() {
            return this.isEditing;
        }

        public boolean isEditingAgain() {
            return this.isEditingAgain;
        }

        public void setEditing(boolean isEditing) {
            boolean wasEditing = this.isEditing;
            this.isEditing = isEditing;
            if (!wasEditing && isEditing) {
                this.isEditingAgain = true;
                this.original = this.text;
            }
        }

        public void setText(String text) {
            this.text = text;
        }

        private boolean equalsOrBothNull(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

