/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contacts;

import com.ericsson.cms.contractmgmt.client.MaxLenTextInputCell;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.model.UiContactType;
import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactValidator;
import com.ericsson.cms.contractmgmt.client.table.AbstractEditableTable;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.SafeHtmlHeader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ContactListTable
extends AbstractEditableTable<UiContact> {
    private static final String ERROR_STYLE = "contract-ValidationView-error";
    private UiContactType contactType;

    public ContactListTable(List<UiContact> contactList, String recordDisplayName) {
        super(contactList, null, recordDisplayName, false);
    }

    @Override
    public List<UiContact> getCollapsedRecordList() {
        ArrayList<UiContact> collapsedList = new ArrayList<UiContact>();
        for (UiContact curContact : this.recordList) {
            if (curContact.isEmpty()) continue;
            collapsedList.add(curContact);
        }
        return collapsedList;
    }

    @Override
    public void addNewRecord() {
        this.getRecords().add(new UiContact());
    }

    public UiContactType getContactType() {
        return this.contactType;
    }

    public void setContactType(UiContactType contactType) {
        this.contactType = contactType;
    }

    @Override
    protected void createTable(CellTable<UiContact> table) {
        Column<UiContact, String> nameColumn = this.createNameColumn();
        table.addColumn(nameColumn, this.createRequiredColumnHeader(this.constants.contactName()));
        Column<UiContact, String> emailColumn = this.createEmailColumn();
        table.addColumn(emailColumn, this.createRequiredColumnHeader(this.constants.contactEmail()));
        Column<UiContact, String> phoneOfficeColumn = this.createPhoneOfficeColumn();
        table.addColumn(phoneOfficeColumn, this.constants.contactPhoneOffice());
        Column<UiContact, String> phoneWorkColumn = this.createPhoneWorkColumn();
        table.addColumn(phoneWorkColumn, this.constants.contactPhoneWork());
        Column<UiContact, String> phoneMobileColumn = this.createPhoneMobileColumn();
        table.addColumn(phoneMobileColumn, this.constants.contactPhoneMobile());
        Column<UiContact, Boolean> notifyColumn = this.createNotifyColumn();
        table.addColumn(notifyColumn, new SafeHtml(){
            private static final long serialVersionUID = 1L;

            public String asString() {
                return ContactListTable.this.constants.contactNotify();
            }
        });
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        Comparator<UiContact> nameCompare = new Comparator<UiContact>(){

            @Override
            public int compare(UiContact o1, UiContact o2) {
                if (o1 != null) {
                    int i = o2 != null ? o1.getName().compareTo(o2.getName()) : 1;
                    return i;
                }
                return -1;
            }
        };
        sortHandler.setComparator(nameColumn, (Comparator)nameCompare);
        sortHandler.setComparator(emailColumn, (Comparator)new Comparator<UiContact>(){

            @Override
            public int compare(UiContact o1, UiContact o2) {
                if (o1 != null) {
                    int i = o2 != null ? o1.getEmail().compareTo(o2.getEmail()) : 1;
                    return i;
                }
                return -1;
            }
        });
        sortHandler.setComparator(phoneMobileColumn, (Comparator)new Comparator<UiContact>(){

            @Override
            public int compare(UiContact o1, UiContact o2) {
                if (o1 != null) {
                    int i = o2 != null ? o1.getPhoneMobile().compareTo(o2.getPhoneMobile()) : 1;
                    return i;
                }
                return -1;
            }
        });
        sortHandler.setComparator(phoneOfficeColumn, (Comparator)new Comparator<UiContact>(){

            @Override
            public int compare(UiContact o1, UiContact o2) {
                if (o1 != null) {
                    int i = o2 != null ? o1.getPhoneOffice().compareTo(o2.getPhoneOffice()) : 1;
                    return i;
                }
                return -1;
            }
        });
        sortHandler.setComparator(phoneWorkColumn, (Comparator)new Comparator<UiContact>(){

            @Override
            public int compare(UiContact o1, UiContact o2) {
                if (o1 != null) {
                    int i = o2 != null ? o1.getPhoneWork().compareTo(o2.getPhoneWork()) : 1;
                    return i;
                }
                return -1;
            }
        });
        sortHandler.setComparator(notifyColumn, (Comparator)new Comparator<UiContact>(){

            @Override
            public int compare(UiContact o1, UiContact o2) {
                if (o1.isNotify()) {
                    if (o2.isNotify()) {
                        return 0;
                    }
                    return 1;
                }
                return -1;
            }
        });
        table.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        table.getColumnSortList().push(nameColumn);
        ColumnSortEvent.fire(table, (ColumnSortList)table.getColumnSortList());
    }

    private Header<?> createRequiredColumnHeader(final String headerName) {
        SafeHtml headerHtml = new SafeHtml(){
            private static final long serialVersionUID = 7221753341040162362L;

            public String asString() {
                return String.valueOf(headerName) + "<span class='nwt-FormContainer-required'> *</span>";
            }
        };
        SafeHtmlHeader header = new SafeHtmlHeader(headerHtml);
        return header;
    }

    private Column<UiContact, String> createNameColumn() {
        Column<UiContact, String> nameColumn = new Column<UiContact, String>((Cell)new MaxLenTextInputCell()){

            public String getValue(UiContact contact) {
                return contact.getName();
            }
        };
        nameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiContact, String>(){

            public void update(int index, UiContact contact, String value) {
                contact.setName(value);
                ContactListTable.this.setDirty();
            }
        });
        nameColumn.setSortable(true);
        nameColumn.setDefaultSortAscending(true);
        return nameColumn;
    }

    private Column<UiContact, String> createEmailColumn() {
        Column<UiContact, String> emailColumn = new Column<UiContact, String>((Cell)new MaxLenTextInputCell(150)){

            public String getCellStyleNames(Cell.Context context, UiContact contact) {
                String styleNames = "";
                if (!ContactValidator.validateEmail(contact.getEmail())) {
                    styleNames = ContactListTable.ERROR_STYLE;
                }
                return styleNames;
            }

            public String getValue(UiContact contact) {
                return contact.getEmail();
            }
        };
        emailColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiContact, String>(){

            public void update(int index, UiContact contact, String value) {
                contact.setEmail(value);
                ContactListTable.this.cellTable.redrawRow(index);
                ContactListTable.this.setDirty();
            }
        });
        emailColumn.setSortable(true);
        emailColumn.setDefaultSortAscending(true);
        return emailColumn;
    }

    private Column<UiContact, String> createPhoneOfficeColumn() {
        Column<UiContact, String> phoneOfficeColumn = new Column<UiContact, String>((Cell)new MaxLenTextInputCell(20)){

            public String getCellStyleNames(Cell.Context context, UiContact contact) {
                String styleNames = "";
                if (!ContactValidator.validatePhone(contact.getPhoneOffice())) {
                    styleNames = ContactListTable.ERROR_STYLE;
                }
                return styleNames;
            }

            public String getValue(UiContact contact) {
                return contact.getPhoneOffice();
            }
        };
        phoneOfficeColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiContact, String>(){

            public void update(int index, UiContact contact, String value) {
                contact.setPhoneOffice(value);
                ContactListTable.this.cellTable.redrawRow(index);
                ContactListTable.this.setDirty();
            }
        });
        phoneOfficeColumn.setSortable(true);
        phoneOfficeColumn.setDefaultSortAscending(true);
        return phoneOfficeColumn;
    }

    private Column<UiContact, String> createPhoneWorkColumn() {
        Column<UiContact, String> phoneWorkColumn = new Column<UiContact, String>((Cell)new MaxLenTextInputCell(20)){

            public String getCellStyleNames(Cell.Context context, UiContact contact) {
                String styleNames = "";
                if (!ContactValidator.validatePhone(contact.getPhoneWork())) {
                    styleNames = ContactListTable.ERROR_STYLE;
                }
                return styleNames;
            }

            public String getValue(UiContact contact) {
                return contact.getPhoneWork();
            }
        };
        phoneWorkColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiContact, String>(){

            public void update(int index, UiContact contact, String value) {
                contact.setPhoneWork(value);
                ContactListTable.this.cellTable.redrawRow(index);
                ContactListTable.this.setDirty();
            }
        });
        phoneWorkColumn.setSortable(true);
        phoneWorkColumn.setDefaultSortAscending(true);
        return phoneWorkColumn;
    }

    private Column<UiContact, String> createPhoneMobileColumn() {
        Column<UiContact, String> phoneMobileColumn = new Column<UiContact, String>((Cell)new MaxLenTextInputCell(20)){

            public String getCellStyleNames(Cell.Context context, UiContact contact) {
                String styleNames = "";
                if (!ContactValidator.validatePhone(contact.getPhoneMobile())) {
                    styleNames = ContactListTable.ERROR_STYLE;
                }
                return styleNames;
            }

            public String getValue(UiContact contact) {
                return contact.getPhoneMobile();
            }
        };
        phoneMobileColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiContact, String>(){

            public void update(int index, UiContact contact, String value) {
                contact.setPhoneMobile(value);
                ContactListTable.this.cellTable.redrawRow(index);
                ContactListTable.this.setDirty();
            }
        });
        phoneMobileColumn.setSortable(true);
        phoneMobileColumn.setDefaultSortAscending(true);
        return phoneMobileColumn;
    }

    private Column<UiContact, Boolean> createNotifyColumn() {
        CheckboxCell checkboxCell = new CheckboxCell();
        Column<UiContact, Boolean> notifyColumn = new Column<UiContact, Boolean>((Cell)checkboxCell){

            public Boolean getValue(UiContact contact) {
                return contact.isNotify();
            }
        };
        notifyColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<UiContact, Boolean>(){

            public void update(int index, UiContact contact, Boolean value) {
                contact.setNotify(value);
                ContactListTable.this.setDirty();
            }
        });
        notifyColumn.setSortable(false);
        return notifyColumn;
    }
}

